<?php

namespace App\Http\Controllers\Financeiro;

use App\Http\Controllers\Controller;
use App\Services\SubGrupoService;
use Illuminate\Http\Request;
use Prettus\Validator\Exceptions\ValidatorException;


class SubGruposController extends Controller
{

    protected $service;

    public function __construct(SubGrupoService $service)
    {
        $this->service = $service;

    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        try
        {
            $subGrupos = $this->service->get();

            return response()->json($subGrupos);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        try {
            $subGrupo = $this->service->insert($request->all());
            return response()->json([
                'message' => 'Sub grupo created',
                'data' => $subGrupo
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $subGrupo = $this->service->getById($id);
        return response()->json(['data' => $subGrupo]);
    }


    /**
     * Display the specified resource.
     *
     * @param int $groupId
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function showByGroup($groupId)
    {
        $response = $this->service->getByGroupId($groupId);
        return response()->json($response);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  string            $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'Sub grupo Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $response = $this->service->delete($id);
        if ($response) return response()->json(['message' => 'Sub grupo deleted']);
        else return response()->json(['message' => 'Sub grupo com conta vinculada'], 500);
    }
}
