<?php

namespace App\Observers;

use App\Entities\Nati\Aliquota;
use Illuminate\Support\Facades\Cache;

class AliquotaObserver
{
    /**
     * Handle the aliquota "created" event.
     *
     * @param  Aliquota  $aliquota
     * @return void
     */
    public function created(Aliquota $aliquota)
    {
        Cache::forget('ListaAliquotas');
    }

    /**
     * Handle the aliquota "updated" event.
     *
     * @param  Aliquota  $aliquota
     * @return void
     */
    public function updated(Aliquota $aliquota)
    {
        Cache::forget('ListaAliquotas');
    }

    /**
     * Handle the aliquota "deleted" event.
     *
     * @param  Aliquota  $aliquota
     * @return void
     */
    public function deleted(Aliquota $aliquota)
    {
        Cache::forget('ListaAliquotas');
    }

    /**
     * Handle the aliquota "restored" event.
     *
     * @param  Aliquota  $aliquota
     * @return void
     */
    public function restored(Aliquota $aliquota)
    {
        Cache::forget('ListaAliquotas');
    }

    /**
     * Handle the aliquota "force deleted" event.
     *
     * @param Aliquota $aliquota
     * @return void
     */
    public function forceDeleted(Aliquota $aliquota)
    {
        Cache::forget('ListaAliquotas');
    }
}
