<?php

namespace App\Repositories\Nati;

use App\Entities\Nati\StockMovimentation;
use App\Validators\Nati\StockMovimentationValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class StockMovimentationRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class StockMovimentationRepositoryEloquent extends BaseRepository implements StockMovimentationRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return StockMovimentation::class;
    }

    /**
     * Specify Validator class name
     *
     * @return mixed
     */
    public function validator()
    {
        return StockMovimentationValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }

}
