<?php

namespace App\Services\Nati;

use App\Entities\Nati\FichaTecnica;
use App\Entities\Nati\Key;
use App\Entities\Nati\MicroTerminal;
use App\Repositories\MicroTerminalRepository;
use App\Validators\Nati\MicroTerminalValidator;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class MicroTerminalService
{
    private $repository;
    private $validator;
    private $keyService;

    public function __construct(MicroTerminalRepository $repository, MicroTerminalValidator $validator, KeyService $keyService)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->keyService = $keyService;
    }

    public function getById($id)
    {
        return $this->repository->find($id);
    }

    public function all()
    {
        return $this->repository->findWhere(['flAtivo' => true]);
    }

    public function create($request)
    {
        DB::beginTransaction();
        try {
            $microTerminal = [

                "idMicroTerminal" => $request['idMicroTerminal'],
                "stMicroTerminal" => $request['stMicroTerminal'],
                "stTipo" => $request['stTipo'],
                "nrPorta" => 6550,
                "nrTeclas" => $request['nrTeclas'],
                "flLeitor" => $request['flLeitor'],
                "flOperador" => 0,
                "stBalanca" => $request['stBalanca'],
                "flModoCheckOut" => 0,
                "idCaixa" => 0,
                "idOrigem" => 1,
                "idDestino" => 1,
                "stMarcaPrint" => "SEM IMPRESSORA",
                "flPrint" => 0,
                "stTipoPorta" => 'SERIAL',
                "flPrintAll" => $request['flPrintAll'],
                "nrCOMDisplay" => 0,
                "stDisplay" => 'SEM DISPLAY',
                "flAtivo" => true,
                "dtAlteracao" => Carbon::now(),
                "nrTabelaPreco" => 1

            ];

            $chave = isset($request['key']) && strlen($request['key']) > 0 ? $request['key'] : '';
            $this->validator->with($microTerminal)->passesOrFail(ValidatorInterface::RULE_CREATE);

            $micro = $this->repository->create($microTerminal);

            if (strlen($chave) > 0) {
                $idMicroterminal = $micro->idMicroTerminal;
                $this->keyService->setKey($chave, $idMicroterminal);
            }

            DB::commit();
            return $micro;
        } catch (\Exception $exception) {
            DB::rollBack();
            throw $exception;
        }
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);

            $chave = $request['key'];

            if (strlen($chave) > 0) {
                $idMicroterminal = $request['idMicroTerminal'];
                $this->keyService->setKey($chave, $idMicroterminal);
            }
//            $m = MicroTerminal::where('idMicroterminal', "$id")->get()->first();

            $this->repository->update($request, $id);
            DB::commit();
//            return $this->repository->find($id);
        } catch (\Exception $exception) {
            DB::rollBack();
            throw $exception;
        }
    }

    public function delete($id)
    {
        DB::beginTransaction();
        try {
            $chave = Key::where('stComponente', $id)->first();
            if ($chave) {
                $idKey = $chave->stChave;
                $this->keyService->unsetKey($idKey);
            }
            // todo deletar registros em mt_ProdutosPrint
            FichaTecnica::where('idMicroterminal', $id)->delete();
            $this->repository->update(['flAtivo' => false], $id);
            DB::commit();
        } catch (\Exception $exception) {
            DB::rollBack();
            throw $exception;
        }
    }
}
