<?php

namespace App\Services\Shared;

use Carbon\Carbon;
use App\Services\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;
use App\Entities\Nati\FormaPagamento;
use App\Validators\FormaPagamentoValidator;
use App\Repositories\ConfigAdquirenteRepository;
use App\Repositories\FormaPagamentoAntigoRepository;
use Prettus\Validator\Contracts\ValidatorInterface;
use test\Mockery\ReturnTypeObjectTypeHint;

class FormaPagamentoService extends Service
{

    protected $repository;
    protected $validator;
    protected $configRepo;

    public function __construct(FormaPagamentoAntigoRepository $repository, FormaPagamentoValidator $validator, ConfigAdquirenteRepository $configRepo)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->configRepo = $configRepo;
    }

    public function get()
    {
        if (Cache::tags(['ListaFormaPagamento'])->has('all')) {
            return Cache::tags(['ListaFormaPagamento'])->get('all');
        } else {
            $response = $this->repository->with('tipo')->findWhere(['flAtivo' => true]);
            Cache::tags(['ListaFormaPagamento'])->put('all', $response, 1440);
            return $response;
        }
    }

    public function getById($id)
    {
        return $this->repository->find($id);
    }

    public function search($string)
    {
        return $this->repository->findWhere([['stFormaPagamento', 'LIKE', '%' . $string . '%']]);
    }

    public function insert($data)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $forma = new FormaPagamento();
        $forma->idFormaPagamento = $this->nextId();
        $forma->stFormaPagamento = Str::upper($data['stFormaPagamento']);
        $forma->idTipo = $data['idTipo'];
        $forma->flTroco = $data['flTroco'];
        $forma->flVenda = $data['flVenda'];
        $forma->flSangria = $data['flVenda'];
        $forma->flGiveDifference = false;
        $forma->flDespesas = $data['flDespesas'];
        $forma->flSenha = $data['flSenha'];
        $forma->flAcionaGaveta = $data['flAcionaGaveta'];
        $forma->stCor = $data['stCor'];
        $forma->stAtalho = $data['stAtalho'];
        $forma->flDelivery = $data['flDelivery'];
        $forma->idBandeira = 0;
        $forma->idTEF = $data['idTEF'];
        $forma->flAtivo = true;
        $forma->flFaturado = false;
        $forma->flVendaBrowser = 0;
        $forma->dtAlteracao = Carbon::now();
        $forma->Order = $data['Order'];
        $forma->parentId = 0;
        $forma->vrTaxa = 0;
        $forma->flAdquirente = false;
        $forma->pagamentoSat = $data['pagamentoSat'];
        $forma->sync = false;
        $forma->idBandeira = 1;

        $forma->save();


        return $forma;
    }

    public function update($data, $id)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->update($data, $id);
    }

    public function delete($id)
    {
        return $this->repository->update(['flAtivo' => false], $id);
    }

    private function nextId()
    {
        return FormaPagamento::max('idFormaPagamento') + 1;
    }
}
