<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxItensTempTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Itens_Temp')) {
            Schema::create('cx_Itens_Temp', function(Blueprint $table){
                $table->integer('idItem', false, true);
                $table->integer('idVenda', false, true);
                $table->integer('idAbertura', false, true);
                $table->integer('idProduto', false, true);
                $table->dateTime('dtData');
                $table->decimal('nrQuantidade',10,3);
                $table->decimal('vrCusto',9,2);
                $table->decimal('vrUnitario',9,2);
                $table->decimal('vrDesconto',9,2);
                $table->boolean('flAtivo');
                $table->integer('idComanda', false,true);
                $table->decimal('idCodProduto',13,0);
                $table->decimal('vrTotal', 9,2);
                $table->decimal('vrTotalCusto', 9,2);
                $table->integer('idOperadorAutorizador', false, true);
                $table->string('stAtendente', 20);
                $table->boolean('flEstoqueBaixado');
                $table->boolean('flPromocao');
                $table->dateTime('dtAlteracao');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Itens_Temp');

    }
}
