<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtMicroterminaisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_Microterminais')) {
            Schema::create('mt_Microterminais', function (Blueprint $table) {
                $table->string('idMicroTerminal',15);
                $table->string('stMicroTerminal',20);
                $table->smallInteger('stTipo');
                $table->integer('nrPorta', false, false);
                $table->smallInteger('nrTeclas');
                $table->float('flLeitor');
                $table->float('flOperador');
                $table->string('stBalanca',15);
                $table->float('flModoCheckOut')->nullable()->default(false);
                $table->smallInteger('idCaixa')->nullable();
                $table->integer('idOrigem')->nullable();
                $table->integer('idDestino')->nullable();
                $table->string('stMarcaPrint',50);
                $table->float('flPrint')->nullable();
                $table->string('stTipoPorta',50)->default('PARALELA');
                $table->float('flPrintAll')->default(false);
                $table->integer('nrCOMDisplay')->default(0);
                $table->string('stDisplay',30)->default('SEM DISPLAY');
                $table->float('flAtivo')->default(true);
                $table->date('dtAlteracao')->default(Carbon::now());
                $table->integer('nrTabelaPreco')->default(1);

                $table->primary('idMicroTerminal');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Microterminais');

    }
}
