<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterMtItens extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasColumn('mt_Itens', 'vrAcrescimo')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->decimal('vrAcrescimo', 9, 2)->default(0);
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'codigo')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('codigo', 14)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'descricao')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('descricao', 29)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'cfop')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('cfop', 4)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'ncm')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('ncm', 8)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'cstIcms')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('cstIcms', 3)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'aliquotaIcms')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->decimal('aliquotaIcms', 9, 2)->default(0);
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'cstPis')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('cstPis', 2)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'aliquotaPis')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->decimal('aliquotaPis', 9, 2)->default(0);
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'cstCofins')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('cstCofins', 2)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'aliquotaCofins')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->decimal('aliquotaCofins', 9, 2)->default(0);
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'ibpt')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->decimal('ibpt', 9, 2)->default(0);
            });
        }
        if(!Schema::hasColumn('mt_Itens', 'medida')){
            Schema::table('mt_Itens', function (Blueprint $table) {
                $table->string('medida', 2)->nullable();
            });
        }
        if(!Schema::hasColumn('mt_atendimentos', 'vrAcrescimo')){
            Schema::table('mt_atendimentos', function (Blueprint $table) {
                $table->decimal('vrAcrescimo', 9, 2)->nullable()->default(0);
            });
        }
        if(!Schema::hasColumn('mt_atendimentos', 'vrTotal')){
            Schema::table('mt_atendimentos', function (Blueprint $table) {
                $table->decimal('vrTotal', 9, 2)->nullable()->default(0);
            });
        }
        if(!Schema::hasColumn('mt_atendimentos', 'uuid')){
            Schema::table('mt_atendimentos', function (Blueprint $table) {
                $table->uuid('uuid')->default(DB::raw('newid()'));
            });
        }

        if(DB::select("SELECT case when (name = 'TR_MT_ITENS_CREATE') then name else '' end as res FROM sys.triggers WHERE name = 'TR_MT_ITENS_CREATE'")){
            DB::statement("
                ALTER TRIGGER  [dbo].[TR_MT_ITENS_CREATE]
                ON [dbo].[mt_Itens] AFTER INSERT
                AS
                BEGIN
                DECLARE @CODIGO varchar;
                DECLARE @IDPRODUTO int;
                DECLARE @IDCOMANDA int;
                DECLARE @NRITEM  int;
                DECLARE @SERVICO bit;
                DECLARE @VRSERVICO decimal(9,2);
                DECLARE @DESCRICAO varchar;
                SET NOCOUNT ON;

                set @CODIGO= (select top(1) idCodigo from prd_codigos where idProduto = (select idProduto from INSERTED));
                set @IDPRODUTO= (select idProduto from INSERTED);
                set @IDCOMANDA= (select idComanda from INSERTED);
                set @NRITEM  = (select nrItem from INSERTED);
                set @SERVICO = (select flExibirTaxaServico from MASTER)
                set @VRSERVICO = (select case when vrTaxaServico > 1 then (vrTaxaServico / 100) else vrTaxaServico end from MASTER)
                set @DESCRICAO = (select descricao from INSERTED);

                IF (@DESCRICAO is null or LEN(@DESCRICAO) = 0) or @codigo is null or LEN(@codigo) = 0
                begin
                update i
                set
                    i.codigo = p.codigo,
                    i.descricao = p.descricao,
                    i.cfop = p.cfop,
                    i.ncm = p.ncm,
                    i.cstIcms = p.cstIcms,
                    i.aliquotaIcms = p.aliquotaIcms,
                    i.cstPis = p.cstPis,
                    i.aliquotaPis = p.aliquotaPis,
                    i.cstCofins = p.cstCofins,
                    i.aliquotaCofins = p.aliquotaCofins,
                    i.medida = p.medida,
                    i.vrAcrescimo = case when @SERVICO = '1' then i.vrTotal * @VRSERVICO else 0 end
                from mt_Itens i
                inner join vw_produtos p on p.idProduto = i.idProduto and i.idComanda = @IDCOMANDA and i.nrItem = @NRITEM
                end

                update mt_Atendimentos set vrAcrescimo = (select sum(vrAcrescimo) from mt_Itens where idComanda = @IDCOMANDA),
                vrTotal = (select sum(vrTotal) from mt_Itens where idComanda = @IDCOMANDA)
                where idComanda = @IDCOMANDA

                END
            ");
        } else {
            DB::statement("
            CREATE TRIGGER  [dbo].[TR_MT_ITENS_CREATE]
            ON [dbo].[mt_Itens] AFTER INSERT
            AS
            BEGIN
            DECLARE @CODIGO varchar;
            DECLARE @IDPRODUTO int;
            DECLARE @IDCOMANDA int;
            DECLARE @NRITEM  int;
            DECLARE @SERVICO bit;
            DECLARE @VRSERVICO decimal(9,2);
            DECLARE @DESCRICAO varchar;
            SET NOCOUNT ON;

            set @CODIGO= (select top(1) idCodigo from prd_codigos where idProduto = (select idProduto from INSERTED));
            set @IDPRODUTO= (select idProduto from INSERTED);
            set @IDCOMANDA= (select idComanda from INSERTED);
            set @NRITEM  = (select nrItem from INSERTED);
            set @SERVICO = (select flExibirTaxaServico from MASTER)
            set @VRSERVICO = (select case when vrTaxaServico > 1 then (vrTaxaServico / 100) else vrTaxaServico end from MASTER)
            set @DESCRICAO = (select descricao from INSERTED);

            IF (@DESCRICAO is null or LEN(@DESCRICAO) = 0) or @codigo is null or LEN(@codigo) = 0
            begin
            update i
            set
                i.codigo = p.codigo,
                i.descricao = p.descricao,
                i.cfop = p.cfop,
                i.ncm = p.ncm,
                i.cstIcms = p.cstIcms,
                i.aliquotaIcms = p.aliquotaIcms,
                i.cstPis = p.cstPis,
                i.aliquotaPis = p.aliquotaPis,
                i.cstCofins = p.cstCofins,
                i.aliquotaCofins = p.aliquotaCofins,
                i.medida = p.medida,
                i.vrAcrescimo = case when @SERVICO = '1' then i.vrTotal * @VRSERVICO else 0 end
            from mt_Itens i
            inner join vw_produtos p on p.idProduto = i.idProduto and i.idComanda = @IDCOMANDA and i.nrItem = @NRITEM
            end

            update mt_Atendimentos set vrAcrescimo = (select sum(vrAcrescimo) from mt_Itens where idComanda = @IDCOMANDA),
            vrTotal = (select sum(vrTotal) from mt_Itens where idComanda = @IDCOMANDA)
            where idComanda = @IDCOMANDA

            END
        ");
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
