<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstMovimentacoesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_Movimentacoes')) {

            DB::statement('CREATE TABLE [dbo].[est_Movimentacoes](
                  [idMovimentacao] [bigint] NOT NULL,
                  [idAbertura] [int] NOT NULL CONSTRAINT [DF_est_Movimentacoes_idAbertura]  DEFAULT ((0)),
                  [idOrigem] [int] NOT NULL,
                  [idDestino] [smallint] NOT NULL,
                  [dtMovimentacao] [smalldatetime] NOT NULL,
                  [stOperador] [nvarchar](20) NOT NULL,
                  [stNotaFiscal] [nvarchar](20) NOT NULL,
                  [flEntrada] [bit] NOT NULL,
                  [flTipoOrigem] [bit] NOT NULL,
                  [flTipoDestino] [bit] NOT NULL,
                  [flAtivo] [bit] NOT NULL,
                  [vrEncargos] [decimal](9, 2) NULL,
                  [stObservacao] [text] NULL,
                  [dtData] [smalldatetime] NULL,
                  [flTipoEstoque] [bit] NOT NULL CONSTRAINT [DF_est_Movimentacoes_flTipoEstoque]  DEFAULT ((0)),
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_est_Movimentacoes_dtAlteracao]  DEFAULT (getdate()),
                  CONSTRAINT [PK_est_Movimentacoes] PRIMARY KEY CLUSTERED
                    (
                      [idMovimentacao] ASC,
                      [idAbertura] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_Movimentacoes');

    }
}
