<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinDevolucaoAlineasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_DevolucaoAlineas')) {

            DB::statement('CREATE TABLE [dbo].[fin_DevolucaoAlineas](
                  [idAlinea] [int] NOT NULL,
                  [stAlinea] [nvarchar](250) NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_fin_DevolucaoAlineas_dtAlteracao]  DEFAULT (getdate()),
                  CONSTRAINT [PK_fin_DevolucaoAlineas] PRIMARY KEY CLUSTERED
                    (
                      [idAlinea] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_DevolucaoAlineas');

    }
}
