<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
<link href="resources/css/toastr.css" rel="stylesheet"/>
<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
<link href="resources/css/custom.css" rel="stylesheet"/>
<?php
error_reporting(0);

require_once "functions.php";

if (strstr($_SERVER['SCRIPT_NAME'], "index.php") === false)
{
	redirect("index.php");
	die;
}

permission(59);

$dt_dia = intval($_POST['dt_dia']);
$dt_mes = intval($_POST['dt_mes']);
$dt_ano = intval($_POST['dt_ano']);
$order = ($_POST['order'] ? $_POST['order'] : "P.stProduto");

?>
<div class="col-md-8 col-md-offset-2" align="center" style="padding-left: 0px">
	<h2>Pendências para Fabricar por Clientes</h2>
	<center><h4>Lista de produtos internos (código menor que 999999) referênte a atendimentos agêndados</h4></center>
</div>

<form name="filterList" method="post" action="?sec=paraFabricarClientes">
	<div class="col-md-12">
	<input type="hidden" name="order" value="P.stProduto" />
	<?
	if ($_POST)
		echo "<input type='hidden' name='enviar' value='Filtrar' />";
	?>
	<table class="tableForm" style="width: auto;" align="center">
		<tr>
			<td>
			<h4>Selecionar um dia específico:
			<input type="text" size="1" name="dt_dia" maxlength="2" value="<?=(!$dt_dia ? date("d") : $dt_dia)?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
			<input type="text" size="1" name="dt_mes" maxlength="2" value="<?=(!$dt_mes ? date("m") : $dt_mes)?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
			<input type="text" size="3" name="dt_ano" maxlength="4" value="<?=(!$dt_ano ? date("Y") : $dt_ano)?>" onkeypress="return removeInvalidChars(event, '0123456789');" />
			<button class="btn btn-primary">Filtrar</button>
			<?
			if ($_POST)
			{
				?>
				<button class="btn btn-primary" onClick="document.location='?sec=paraFabricarClientes'">Exibir Todos</button>
				<?
			}
			?>
			</td>
		</tr>
	</table>
	</div>
	<br>
	<table class="table table-bordered">
		<thead>
			<th onclick="orderList('A.idAtendimento')" style="cursor: hand;">PEDIDO</th>
			<th onclick="orderList('A.nrPedido')" style="cursor: hand;">CONTROLE</th>
			<th onclick="orderList('T.stCliente')" style="cursor: hand;">CLIENTE</th>
			<th onclick="orderList('X.nrTelefone')" style="cursor: hand;">TELEFONE</th>
			<th onclick="orderList('A.dtAgendarPedido')" style="cursor: hand;">HORA</th>
			<th onclick="orderList('P.stProduto')" style="cursor: hand;">PRODUTO</th>
			<th onclick="orderList('nrQuantidade')" style="cursor: hand;">QUANTIDADE</th>
			<th onclick="orderList('I.stOBS')" style="cursor: hand;">OBSERVAÇÃO</th>
		</thead>
		<?
		$sql = "SELECT A.idAtendimento, T.stCliente, A.idCliente, I.stOBS, P.stProduto, M.stMedida, M.flFracionado, SUM(I.nrQuantidade) AS nrQuantidade, A.dtAgendarPedido, A.nrPedido
				FROM dlv_Atendimentos A
				INNER JOIN dlv_Itens I ON A.idAtendimento = I.idAtendimento
				INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
				INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
				INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
				INNER JOIN dlv_Clientes T ON A.idCliente = T.idCliente
				WHERE A.flAgendarPedido = 'true' AND A.stStatus IN ('F','P') AND C.idCodigo <> '-100' AND C.idCodigo <= '999999' AND A.flAtivo = 'true' ".($_POST['enviar'] ? "AND A.dtAgendarPedido BETWEEN '$dt_ano-$dt_mes-$dt_dia 00:00:00' AND '$dt_ano-$dt_mes-$dt_dia 23:59:59' " : "")."

				GROUP BY A.idAtendimento, A.idCliente, T.stCliente, I.stOBS, P.stProduto, M.stMedida, M.flFracionado, A.dtAgendarPedido, A.nrPedido
				ORDER BY YEAR(A.dtAgendarPedido), MONTH(A.dtAgendarPedido), DAY(A.dtAgendarPedido), $order";

		$res = mssql_query($sql);
		$cnt = mssql_num_rows($res);

		if ($cnt > 0)
		{
			$old = "";

			while ($arr = mssql_fetch_array($res))
			{
			    $tel = mssql_fetch_array(mssql_query("select min(nrTelefone) as nrTelefone from dlv_Telefones where idCliente =" . $arr['idCliente']));
				$stStatus = "";
				$nrOciosidade = 0;
                $nrQuantidade = 0;
				switch ($arr['stStatus'])
				{
					case "F":
						$stStatus = "FORMULAÇÃO";
						break;
					case "P":
						$stStatus = "PENDENTE";
						break;
				}

				if ($arr['flFracionado'])
					$nrQuantidade = number_format($arr['nrQuantidade'], 3, ".", "");
				else
					$nrQuantidade = intval($arr['nrQuantidade']);

				if (date("Y-m-d", strtotime($arr['dtAgendarPedido'])) != $old)
				{
					?>
					<tr>
						<td colspan="8" class="trTitleLight" align="center"><?=date("d/m/Y", strtotime($arr['dtAgendarPedido']))?></td>
					</tr>
					<?
					$old = date("Y-m-d", strtotime($arr['dtAgendarPedido']));
				}

				echo "<tr bgcolor=".(($c++&1)? "#FFFFFF" : "#F0F0F0").">";
				?>
				<td><?=$arr['idAtendimento']?></td>
				<td><?=$arr['nrPedido']?></td>
				<td><?=$arr['stCliente']?></td>
				<td><?=$tel['nrTelefone']?></td>
				<td><?=date("H:i", strtotime($arr['dtAgendarPedido']))?></td>
				<td><?=$arr['stProduto']?></td>
				<td><?=$nrQuantidade." ".$arr['stMedida']?></td>
				<td><?=$arr['stOBS']?></td>
				<?
				echo "</tr>";
			}
		}
		else
		{
			?>
			<tr>
				<td colspan="8" align="center">NENHUM PENDÊNCIA ENCONTRADA</td>
			</tr>
			<?
		}
		?>
	</table>
</form>
<script>
function orderList(coluna)
{
    document.getElementById('order').value = coluna;
    document.forms['filterList'].submit();
}
</script>
<script src="resources/js/jquery-2.1.4.js"></script>
<script src="resources/js/bootstrap.min.js"></script>
<script src="resources/js/datatables.min.js"></script>
<script src="resources/js/toastr.js"></script>
<script src="resources/js/sweetalert2.min.js"></script>
<script src="resources/js/functions.js"></script>
