<?php
require_once "../functions.php";
db_conn();

if (!autorization(35)){
    header("LOCATION: ../?sec=erro&sub=2");
    die;
}

$idAbertura = htmlspecialchars($_GET['ida'], ENT_QUOTES);
$idFormaPagamento = htmlspecialchars($_GET['idf'], ENT_QUOTES);
$closed = htmlspecialchars($_GET['closed'], ENT_QUOTES);

?>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Detalhes de Vendas realizadas</title>
    <script type="text/javascript" language="JavaScript" src="../js/lib.js"></script>
    <link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
    <link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="resources/css/toastr.css" rel="stylesheet"/>
    <link href="resources/css/sweetalert2.css" rel="stylesheet"/>
    <link href="resources/css/custom.css" rel="stylesheet"/>
</head>
<body >
    <?
    $res = mssql_query("SELECT * FROM cx_FormasPagamento WHERE idFormaPagamento = '$idFormaPagamento'");
    $arr = mssql_fetch_array($res);
    $stFormaPagamento = strtolower($arr['stFormaPagamento']);
    $idTipo = $arr['idTipo'];
    ?>
    <table class="table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
        <caption class="table-caption"><b>Detalhes de Vendas Realizadas</b></caption>
        <thead>
            <tr>
                <td class="tdStyle" width="5%"><b>Venda</b></td>
                <td class="tdStyle" width="15%"><b>Cliente</b></td>
                <td class="tdStyle" width="15%"><b>Data</b></td>
                <td class="tdStyle" width="15%"><b>Valor <?php echo $stFormaPagamento?></b></td>
                <td class="tdStyle" width="15%"><b>Valor Venda</b></td>
                <td class="tdStyle" width="10%"><center><b>Troco À Pagar</b></center></td>
                <td class="tdStyle" width="15%"><b>Valor Real Pago</b></td>
                <td class="tdStyle" width="10%"><b>Ação</b></td>
            </tr>
        </thead>
        <?php
        if($idFormaPagamento){
            $sql = "SELECT X.idVenda, X.idFicha, X.vrFormaPagamento, X.idAbertura, X.dtData, C.stCliente, (V.vrTotal - V.vrDesconto + V.vrAcrescimo) as vrTotal FROM
            (SELECT * FROM cx_FichaRecebimentos_Temp UNION SELECT * FROM cx_FichaPagamentos)X INNER JOIN
            (SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
                flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas_Temp
                UNION
                SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
                flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas) V
ON X.idVenda = V.idVenda AND X.idAbertura = V.idAbertura INNER JOIN dlv_Clientes C ON V.idCliente = C.idCliente WHERE X.flAtivo = '1' AND X.idAbertura = ".$idAbertura."
AND X.idFormaPagamento = ".$idFormaPagamento." AND X.vrFormaPagamento > '0' ORDER BY 1";
$res = mssql_query($sql);
}

$vlr_total_vendas = 0;
while ($arr = mssql_fetch_array($res)){
    $dtData = strtotime($arr['dtData']);
    $dtData = date("d/m/y H:i:s", $dtData);

    $vrValorForma = "";
    if (!$arr['idBanco'] || $idTipo != 11)
        $vrValorForma = "<font size=\"2\">R$ ".number_format($arr['vrFormaPagamento'], 2, ",", ".")."";
    else{
        $stAlertCheque = "Número do Banco: ".$arr['nrBanco']."\\n";
        $stAlertCheque .= "Banco: ".$arr['stBanco']."\\n";
        $stAlertCheque .= "Número do Cheque: ".$arr['nrCheque']."\\n";
        $stAlertCheque .= "Agência: ".$arr['nrAgenciaCheque']."\\n";
        $stAlertCheque .= "Conta-Corrente: ".$arr['nrContaCheque']."\\n";
        $stAlertCheque .= "Data de Depásito: ".date("d/m/Y", strtotime($arr['dtDepositoCheque']));
        $vrValorForma = "<font size=\"2\"><a href=\"javascript:alert('$stAlertCheque')\">R$ ".number_format($arr['vrFormaPagamento'], 2, ",", ".")."</a>";
    }

    ?>
    <tr>
        <td class="tdStyle"><?php echo $arr['idVenda']?></td>
        <td class="tdStyle"><a href="javascript:alert('<?php echo $arr['stCliente']?>')"><?php echo $arr['stCliente']?></a></td>
        <td class="tdStyle"><nobr><?php echo $dtData?> H</nobr></td>
        <td class="tdStyle" align="right"><?php echo $vrValorForma?></td>
        <td class="tdStyle" align="right">R$ <?php echo number_format($arr['vrTotal'], 2, ",", ".")?></td>
        <td class="tdStyle" align="right">

            <?php echo ($arr['vrFormaPagamento'] > $arr['vrTotal'] ? 'TROCO:<br />' : ($arr['vrFormaPagamento'] < $arr['vrTotal'] ? 'À PAGAR:<br />' : ''))?>
            R$ <?php echo number_format(($arr['vrFormaPagamento'] - $arr['vrTotal']), 2, ',', '.')?>

        </td>
        <td class="tdStyle" align="right">

            R$ <?php echo ($arr['vrFormaPagamento'] == $arr['vrTotal'] ? $arr['vrTotal'] : ($arr['vrFormaPagamento'] > $arr['vrTotal'] ? $arr['vrTotal'] : $arr['vrFormaPagamento']))?>

        </td>
        <td class="tdStyle">
            <table width="100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="tdStyle" align="center">
                        <?php if (!$closed) { ?>
                        <a href="ver_alterarforma.php?idv=<?php echo $arr['idVenda']?>&ida=<?php echo $idAbertura?>&idfi=<?php echo $arr['idFicha']?>&idfo=<?php echo $idFormaPagamento?>" data-toogle="tooltip" title='Alterar'><span class="glyphicon glyphicon-pencil"></span></a>
                        <?php } ?>
                    </td>
                    <td>
                        <a href="ver_itensvenda<?php echo ($closed ? "2" : "")?>.php?idv=<?php echo $arr['idVenda']?>&ida=<?php echo $idAbertura?>" data-toogle="tooltip" title='Visualizar'><span class="glyphicon glyphicon-search"></span></a>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <?
    $vlr_total_vendas += ($arr['vrFormaPagamento'] == $arr['vrTotal'] ? $arr['vrTotal'] : ($arr['vrFormaPagamento'] > $arr['vrTotal'] ? $arr['vrTotal'] : $arr['vrFormaPagamento']));
    $somaTotal += $arr['vrTotal'];
    $somaFormaPagamento += $arr['vrFormaPagamento'];
}
?>
<tr>
    <td class="tdStyle" colspan="6" align="center"><b>TOTAL</b></td>
    <td class="tdStyle" align="right"><b>R$ <?php echo number_format($vlr_total_vendas, 2, ",", ".")?></b></td>
    <td class="tdStyle"></td>
</tr>
</table>
<br>
<table class="table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
    <thead>
        <tr>
            <td class="tdStyle" width="9%"><b>Vaucher</b></td>
            <td class="tdStyle" width="32%"><b>Operador Autorizador</b></td>
            <td class="tdStyle" width="25%"><b>Data</b></td>
            <td class="tdStyle" width="25%"><b>Valor</b></td>
            <td class="tdStyle" width="9%"><b>Ação</b></td>
        </tr>
    </thead>
    <?
    $sql2 = "SELECT V.*, O.* FROM cx_Vaucher V
    INNER JOIN op_Operadores O
    ON V.idOperadorAutorizador = O.idOperador
    WHERE idAbertura = '$idAbertura'
    AND idFormaPagamento = '$idFormaPagamento'
    ";

    $resp = mssql_query($sql2);

    while($arrp = mssql_fetch_array($resp)){
        $somaVauchers += $arrp['vrVaucher'];
        ?>
        <tr>
            <td class="tdStyle"><?php echo $arrp['idAbertura']."_".$arrp['idVaucher']?></td>
            <td class="tdStyle"><?php echo $arrp['stApelido']?></td>
            <td class="tdStyle"><nobr><?php echo $dtData?> H</nobr></td>
            <td class="tdStyle" align="right"><?php echo $arrp['vrVaucher']?></td>
            <td class="tdStyle">
                <table width="100%" cellspacing="0" cellpadding="0">
                    <tr>
                        <td class="tdStyle" align="center">
                            <?php if (!$closed) { ?>
                            <a href="ver_alterarforma.php?idv=<?php echo $arr['idVenda']?>&ida=<?php echo $idAbertura?>&idfi=<?php echo $arr['idFicha']?>&idfo=<?php echo $idFormaPagamento?>"><img src="../imagens/botao_editar.gif" border="0" alt="Alterar"></a>
                            <?php } ?>
                            <a href="ver_itensvenda<?php echo ($closed ? "2" : "")?>.php?idv=<?php echo $arr['idVenda']?>&ida=<?php echo $idAbertura?>"><img src="../imagens/botao_selecionar.gif" border="0" alt="Detalhes"></a>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <?
    }
    ?>
    <tr>
        <td class="tdStyle" colspan="3" align="center"><b>TOTAL</b></td>
        <td class="tdStyle" align="right"><b>R$ <?php echo number_format($somaVauchers, 2, ",", ".")?></b></td>
        <td class="tdStyle"></td>
        <td class="tdStyle"></td>
    </tr>
</table>
<?
    if ($idFormaPagamento == 1) {
    ?>
        <hr>
        <center><font face="arial" size="3"><b>Detalhes de depósitos em Contas</b></font></center>
        <br>
        <table width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
            <tr bgcolor="#000000">
                <td width="25%"><font size="2" color="#FFFFFF"><b>Cliente</b></font></td>
                <td width="17%"><font size="2" color="#FFFFFF"><b>Data</b></font></td>
                <td width="20%"><font size="2" color="#FFFFFF"><b>Tipo</b></font></td>
                <td width="15%"><font size="2" color="#FFFFFF"><b>Valor</b></font></td>
            </tr>
            <?
                if (is_numeric($idAbertura))
                {
                    $sql = "SELECT p.dtData, p.vrPagamento, c.stCliente, f.stFormaPagamento ".
                        "FROM cx_Gerenciador g ".
                        "INNER JOIN cli_Pagamento p ON g.idAbertura = p.idAbertura ".
                        "INNER JOIN dlv_Clientes c ON p.idCliente = c.idCliente ".
                        "INNER JOIN cx_FormasPagamento f ON p.idFormaPagamento = f.idFormaPagamento ".
                        "WHERE g.idAbertura = '$idAbertura' AND p.flAtivo = '1' AND p.vrPagamento > 0";
                }
                else
                {
                    $sql = "SELECT p.dtData, p.vrPagamento, c.stCliente, f.stFormaPagamento ".
                        "FROM cx_Gerenciador g ".
                        "INNER JOIN cli_Pagamento p ON g.idAbertura = p.idAbertura ".
                        "INNER JOIN dlv_Clientes c ON p.idCliente = c.idCliente ".
                        "INNER JOIN cx_FormasPagamento f ON p.idFormaPagamento = f.idFormaPagamento ".
                        "WHERE g.flAberto = '1' AND g.flAberto = '1' AND p.flAtivo = '1' AND p.vrPagamento > 0";
                }

            $res = mssql_query($sql);

            while ($arr = mssql_fetch_array($res))
            {
                $dtData = strtotime($arr['dtData']);
                $dtData = date("d/m/y H:i", $dtData);

                echo "<tr bgcolor=".(($c++&1)? "#FFFFFF" : "#F0F0F0").">";
                ?>
                <td><font size="2"><?php echo $arr['stCliente']?></font></td>
                <td><font size="2"><?php echo $dtData?></font></td>
                <td><font size="2"><?php echo $arr['stFormaPagamento']?></font></td>
                <td align="right"><font size="2">R$ <?php echo  ($arr['vrPagamento'] ? $arr['vrPagamento'] : "0.00") ?></font></td>
                <?
                echo "</tr>";
            }

            if (is_numeric($idAbertura))
            {
                $sql = "SELECT SUM(vrPagamento) as vrPagamento ".
                    "FROM cli_Pagamento ".
                    "WHERE flAtivo = '1' AND idAbertura = '$idAbertura'";
            }
            else
            {
                $sql = "SELECT SUM(p.vrPagamento) as vrPagamento ".
                    "FROM cli_Pagamento p ".
                    "INNER JOIN cx_Gerenciador g ON p.idAbertura = g.idAbertura ".
                    "WHERE p.flAtivo = '1' AND g.flAberto = '1'";
            }

            $res = mssql_query($sql);
            $arr = mssql_fetch_array($res);
            ?>
            <tr>
                <td bgcolor="#666666" colspan="3"><font size="2" color="#FFFFFF"><b>Valor Total:</b></font></td>
                <td bgcolor="#666666" align="right"><font size="2" color="#FFFFFF"><b>R$ <?php echo  ($arr['vrPagamento'] ? $arr['vrPagamento'] : "0.00") ?></b></font></td>
            </tr>
        </table>

    <?php } ?>

<script type="text/javascript">
    window.opener.$(document).ready(function(){
        var block = window.opener.$("body").click(function() { alert('Aguarde a tela recarregar por completo.. '); return false; });

        var CAMPOS  = [];
        var VALORES = [];
        var i = 0;

        window.opener.$("input[type='text']").each(function(){
            if(!window.opener.$(this).attr("readonly")){
                CAMPOS[i]  = window.opener.$(this).attr("name");
                VALORES[i] = window.opener.$(this).attr("value");
                i++;
            }
        });

        window.opener.$("span.msg_load_value").empty().html('<span class="alert">Recalculando valores, Aguarde...</span>');
        window.opener.location.reload();
        window.opener.$("span.msg_load_value").empty().html('<span class="alert">Recalculando valores, Aguarde...</span>');

        setTimeout(function(){
            block = null;
            window.opener.$.each(CAMPOS, function(key, value){
                window.opener.$("input[name='"+CAMPOS[key]+"']").val(VALORES[key]);
                window.opener.$("input[name='"+CAMPOS[key]+"']").keydown();
            });
            window.opener.$("span.msg_load_value").empty();
        }, 4000);

    }
    );
</script>
</body>
</html>
