<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Bootstrap Admin App">
    <meta name="keywords" content="app, responsive, jquery, bootstrap, dashboard, admin">
    <link rel="icon" type="image/x-icon" href="icone-delivery.ico">
    <title>NATI - DELIVERY</title>
    <!-- =============== VENDOR STYLES ===============-->

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Nati Retaguarda')); ?></title>

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">

</head>

<body>
<div class="wrapper" id="app">
    <!-- top navbar-->
    <header class="topnavbar-wrapper">
        <?php echo $__env->make('delivery.layouts.topnavbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- END Top Navbar-->
    </header>

    <!-- sidebar-->
    <aside class="aside-container">
       <?php echo $__env->make('delivery.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </aside>
    <!-- offsidebar-->
    <aside class="offsidebar d-none">
        <?php echo $__env->make('delivery.layouts.offsidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </aside>
    <!-- Main section-->
    <section class="section-container">
        <!-- Page content-->
        <div class="content-wrapper">
            <div class="content-heading">

                <div>Delivery
                    <?php $__env->startSection('page-title'); ?>

                    <?php echo $__env->yieldSection(); ?>
                </div>
            </div>
            <?php echo $__env->yieldContent('content'); ?>

        </div>
    </section>
    <!-- Page footer-->
    <?php echo $__env->make('delivery.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</div>

<!-- Scripts -->
<script src="<?php echo e(asset('js/manifest.js')); ?>"></script>
<script src="<?php echo e(asset('js/vendor.js')); ?>"></script>
<script src="<?php echo e(asset('js/app.js')); ?>"></script>
<?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH E:\www\villagio\resources\views/delivery/layouts/app.blade.php ENDPATH**/ ?>