<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Database\Factories\CompanyFactory;

class Company extends Model implements Transformable
{
    use TransformableTrait, HasFactory;

    protected $table = 'company';
    protected $primaryKey = 'id';
    public $incrementing = false;
    public $timestamps = true;

    protected $fillable = [
        'id',
        'email',
        'nome',
        'cnpj',
        'cep',
        'rua',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'telefone',
        'prefixo',
        'paymentProvider',
        'paymentProviderClientId',
        'paymentProviderSubscriptionId',
        'emails_cc'
    ];

    protected $casts = [
        'suspended' => 'boolean',
        'active' => 'boolean'
    ];


    /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return CompanyFactory::new();
    }

}
