<?php

namespace App\Entities;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class PaymentForm extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cx_FichaPagamentos';
    protected $primaryKey = ['idFicha', 'idVenda', 'idAbertura'];

    public $timestamps = false;
    public $incrementing = false;

    protected $hidden = [
        'idFicha',
        'idVenda',
        'idAbertura',
        'idFormaPagamento',
        'vrFormaPagamento',
        'dtdata',
        'flTroco',
        'flAtivo',
        'dtAlteracao',
        'idBanco',
        'nrCheque',
        'nrAgenciaCheque',
        'nrContaCheque',
        'dtDepositoCheque',
        'flVaucher',
        'formaPagamento'
    ];

    protected $fillable = [
        'id',
        'id_venda',
        'id_open',
        'id_payment',
        'value_payment',
        'date',
        'is_change',
        'active',
        'update_date',
        'is_vaucher',
        'adiquirente',
        'bandeira',
        'autorizacao',
        'parcelas',
        'bin',
        'nsu',
        'tipo_pagamento',
        'modalidade_pagamento',
        'flSentConciliacao',
    ];

    protected $maps = [
        'id' => 'idFicha',
        'id_venda' => 'idVenda',
        'id_open' => 'idAbertura',
        'id_payment' => 'idFormaPagamento',
        'value_payment' => 'vrFormaPagamento',
        'date' => 'dtdata',
        'is_change' => 'flTroco',
        'active' => 'flAtivo',
        'update_date' => 'dtAlteracao',
        'is_vaucher' => 'flVaucher',
        'id_type_payment' => 'formaPagamento.idTipo',
        'payment' => 'formaPagamento.stFormaPagamento'
    ];

    protected $appends = [
        'id',
        'id_venda',
        'id_open',
        'id_payment',
        'value_payment',
        'date',
        'is_change',
        'active',
        'update_date',
        'is_vaucher',
        'id_type_payment',
        'payment'
    ];

    protected $casts = [
        'flTroco' => 'boolean',
        'flVaucher' => 'boolean',
        'flAtivo' => 'boolean'
    ];

    public function formaPagamento()
    {
        return $this->belongsTo(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }
}
