<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class SaleDetailsTemp extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_DetalhesVendas_Temp';

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idVenda',
        'idAbertura',
        'idComanda',
        'idMesa',
        'dtData',
        'dtAlteracao'
    ];

    public function venda()
    {
        return $this->belongsTo(SaleTemp::class, 'idVenda');
    }
}
