<?php


namespace App\Http\Controllers\Delivery;


use App\Entities\Nati\Product;
use App\Http\Controllers\Controller;
use App\Services\Nati\ProductService;

class ProductsController extends Controller
{
    protected $productService;

    public function __construct(ProductService $productService)
    {
        $this->productService = $productService;
    }

    public function search($search)
    {
        try {
            $res = Product::select([
                'prd_produtos.idProduto AS id',
                'stProdutoAbreviado AS descricao',
                'vrUnitario AS preco',
                'idCodigo AS codigo'
            ])
                ->join('prd_codigos', 'prd_produtos.idProduto', '=', 'prd_Codigos.idProduto')
                ->where('prd_Produtos.flAtivo', true)
                ->where(function ($query) use ($search) {
                    $query->where('prd_Codigos.idCodigo', "$search")
                        ->orWhere('prd_Produtos.stProdutoAbreviado', 'LIKE', "%$search%");
                })
                ->where('prd_Codigos.idCodigo', '<>', '-100')
                ->get();

            return response()->json($res);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }

    }

}
