<?php

namespace App\Http\Controllers\Financeiro;

use App\Entities\Financeiro\Bandeira;
use App\Http\Controllers\Controller;
use App\Services\BandeiraService;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\BandeiraCreateRequest;
use App\Http\Requests\BandeiraUpdateRequest;
use App\Repositories\BandeiraRepository;
use App\Validators\BandeiraValidator;
use Yajra\Datatables\Datatables;


class BandeirasController extends Controller
{

    protected $service;


    public function __construct(BandeiraService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try
        {
            $bandeiras = $this->service->get();

            return response()->json([
                'data' => $bandeiras,
            ],200);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 500);
        }
    }

    /**
     * @return mixed
     */
    public function dataTable()
    {
        $bandeiras = Bandeira::query();

        return Datatables::of($bandeiras)->make(true);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  BandeiraCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(BandeiraCreateRequest $request)
    {
        try {
            $bandeiras = $this->service->insert($request->all());
            return response()->json([
                'message' => 'Bandeiras created',
                'data' => $bandeiras
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        try
        {
            $bandeira = $this->service->getById($id);

            return response()->json([
                'data' => $bandeira,
            ],200);
        }
        catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        }
        catch (\Exception $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  BandeiraUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(BandeiraUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'Bandeira Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->service->delete($id);
        return response()->json(['message' => 'grupo deleted']);
    }
}
