<?php

namespace App\Http\Controllers\Financeiro;

use App\Entities\Financeiro\CentroDeCusto;
use App\Http\Controllers\Controller;
use App\Services\CentroDeCustoService;

use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\CentroDeCustoCreateRequest;
use App\Http\Requests\CentroDeCustoUpdateRequest;
use Yajra\Datatables\Datatables;


class CentroDeCustosController extends Controller
{

    /**
     * @var CentroDeCustoService
     */
    protected $service;

    public function __construct(CentroDeCustoService $service) {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {
        return response()->json($this->service->get());
    }

//    public function dataTable()
//    {
//        $centro_de_custos = CentroDeCusto::query()->where('idCentroCusto', '>', '0');
//
//        return Datatables::of($centro_de_custos)->make(true);
//    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CentroDeCustoCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(CentroDeCustoCreateRequest $request)
    {
        try {
            $centroDeCusto = $this->service->insert($request->all());
            return response()->json(['data' => $centroDeCusto]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id) {

        $response = $this->service->getById($id);
        return response()->json(['data' => $response]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  CentroDeCustoUpdateRequest $request
     * @param  string            $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(CentroDeCustoUpdateRequest $request, $id) {

        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json(['data' => $response]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id) {

        $this->service->delete($id);
        return response()->json(['message' => 'Success']);
    }
}
