<?php

namespace App\Http\Controllers\Financeiro;

use App\Entities\Pagamento;
use App\Http\Controllers\Controller;
use App\Services\PagamentoService;
use Illuminate\Http\Request;

use App\Http\Requests;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\PagamentoCreateRequest;
use App\Http\Requests\PagamentoUpdateRequest;
use App\Repositories\PagamentoRepository;
use App\Validators\PagamentoValidator;
use Yajra\Datatables\Datatables;

class PagamentosController extends Controller
{

    protected $service;


    public function __construct(PagamentoService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pagamentos = $this->service->get();

        return response()->json(['data' => $pagamentos]);
    }

    public function dataTable()
    {
        $pagamentos = Pagamento::query();

        return Datatables::of($pagamentos)->make(true);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  PagamentoCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(PagamentoCreateRequest $request)
    {
        try {
            $pagamento = $this->service->insert($request->all());
            return response()->json([
                'message' => 'pagamento created',
                'data' => $pagamento
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $pagamento = $this->service->getById($id);
        return response()->json(['data' => $pagamento]);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  PagamentoUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(PagamentoUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'pagamento Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->service->delete($id);
        return response()->json(['message' => 'pagamento deleted']);
    }
}
