<?php

namespace App\Http\Controllers;

use App\Entities\Master;
use App\Entities\VwOrdersDelivery;
use App\Http\Controllers\Controller;
use App\Reports\MyReport;
use App\Reports\SalesByCustomer;
use App\Repositories\SangriaRepository;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Services\Reports\CommissionReportService;
use Illuminate\Support\Str;

class ReportsController extends Controller
{
    protected $service;
    protected $sangriaRepository;
    protected $suprimentosRepository;

    public function __construct(CommissionReportService $service, SangriaRepository $sangriaRepository)
    {
        $this->service = $service;
        $this->sangriaRepository = $sangriaRepository;
    }

    public function vendas()
    {
        $data = [
            'company' => Master::first(),
            'version' => '6.0.2.4'
        ];
        //        $query = "SELECT m.stMedida, m.flFracionado, i.idCodProduto, p.nrNcm ,i.idProduto, p.stProduto, SUM(i.nrQuantidade) as nrQuantidade, SUM(i.vrTotal - i.vrDesconto) as vrTotal
        //                    ,  X.stSetor
        //                    FROM (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) i
        //                    INNER JOIN prd_Produtos p ON i.idProduto = p.idProduto
        //                    INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
        //                    INNER JOIN cx_Gerenciador g ON i.idAbertura = g.idAbertura
        //                    INNER JOIN prd_Setores X ON P.idSetor = X.idSetor
        //                    WHERE i.flAtivo = '1' AND i.dtData BETWEEN '2020-01-01 00:00:00' AND '2020-10-05 23:59:59'
        //                    AND (g.idAbertura IN (1,2,3,4,5,6,7,8)) and p.idSetor in (1,10,11,20,25,30,40,41,60,80,101,102,105,114,115,119,121,133,139,144,155)
        //                    GROUP BY i.idCodProduto, p.nrNcm,i.idProduto, p.stProduto, m.stMedida, m.flFracionado,  X.stSetor
        //                    ORDER BY nrQuantidade DESC";
        //
        //        $data['vendas'] =  DB::select($query);

        $report = new MyReport;
        $report->run();
        return view("reports.vendas")->with("report", $report);

        //        return view('nati.reports.vendas')->with('data', $data);
    }

    public function vendasClientes()
    {
        $data = [
            'company' => Master::first(),
            'version' => '6.0.2.4'
        ];

        $report = new SalesByCustomer;
        $report->run();
        return view('reports.SalesByCustomer')->with('report', $report)->with('data', $data);
    }

    public function sales()
    {
        try {
            $query = "SELECT m.stMedida, m.flFracionado, i.idCodProduto, p.nrNcm ,i.idProduto, p.stProduto, SUM(i.nrQuantidade) as nrQuantidade, SUM(i.vrTotal - i.vrDesconto) as vrTotal
                    ,  X.stSetor
                    FROM (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) i
                    INNER JOIN prd_Produtos p ON i.idProduto = p.idProduto
                    INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
                    INNER JOIN cx_Gerenciador g ON i.idAbertura = g.idAbertura
                    INNER JOIN prd_Setores X ON P.idSetor = X.idSetor
                    WHERE i.flAtivo = '1' AND i.dtData BETWEEN '2020-01-01 00:00:00' AND '2020-10-05 23:59:59'
                    AND (g.idAbertura IN (1,2,3,4,5,6,7,8)) and p.idSetor in (1,10,11,20,25,30,40,41,60,80,101,102,105,114,115,119,121,133,139,144,155)
                    GROUP BY i.idCodProduto, p.nrNcm,i.idProduto, p.stProduto, m.stMedida, m.flFracionado,  X.stSetor
                    ORDER BY nrQuantidade DESC";
            $result = DB::select($query);

            return response()->json($result);
        } catch (Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function sumary(Request $request)
    {
        $fd = Carbon::createFromFormat('d/m/Y', $request['firstDate'])->toDateString();
        $first_date = $fd . ' 00:00:00';
        $ld = Carbon::createFromFormat('d/m/Y', $request['lastDate'])->toDateString();
        $last_date = $ld . ' 23:59:59';

        $temp = DB::table('cx_vendas_temp')
            ->select(
                DB::raw("CAST(dtData AS DATE) as date"),
                DB::raw('sum(CASE WHEN flAtivo = 1 THEN vrTotal ELSE 0 END) as vendas'),
                DB::raw('sum(CASE WHEN flAtivo = 0 THEN vrTotal ELSE 0 END) as cancelamentos'),
                DB::raw('sum(vrDesconto) as descontos')
            )
            ->whereBetween(DB::raw('cast(dtData AS DATE)'), [$first_date, $last_date])
            ->groupBy(DB::raw("CAST(dtData AS DATE)"));

        $vendas = DB::table('cx_vendas')
            ->select(
                DB::raw("CAST(dtData AS DATE) as date"),
                DB::raw('sum(CASE WHEN flAtivo = 1 THEN vrTotal ELSE 0 END) as vendas'),
                DB::raw('sum(CASE WHEN flAtivo = 0 THEN vrTotal ELSE 0 END) as cancelamentos'),
                DB::raw('sum(vrDesconto) as descontos')
            )
            ->whereBetween(DB::raw('cast(dtData AS DATE)'), [$first_date, $last_date])
            ->union($temp)
            ->groupBy(DB::raw("CAST(dtData AS DATE)"));

        $result = DB::table(DB::raw("({$vendas->toSql()}) as x"))
            ->select(
                DB::raw('date'),
                DB::raw('sum(x.vendas) as vendas'),
                DB::raw('sum(x.cancelamentos) as cancelamentos'),
                DB::raw('sum(x.descontos) as descontos'),
                DB::raw('sum(x.vendas - x.cancelamentos - x.descontos) as liquido')
            )
            ->mergeBindings($vendas)
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->get();

        $res = [];
        $totais = [
            'vendas' => $result->sum('vendas'),
            'cancelamentos' => $result->sum('cancelamentos'),
            'descontos' => $result->sum('descontos')
        ];

        foreach ($result as $venda) {

            array_push($res, collect([
                'name' => Carbon::parse($venda->date)->format('d/m'),
                'series' => [
                    ['name' => 'Vendas', 'value' => (float)$venda->vendas],
                    ['name' => 'Cancelamentos', 'value' => (float)$venda->cancelamentos],
                ]
            ]));
        }

        $data['data'] = $res;
        $data['totais'] = $totais;
        $data['table'] = $result;
        return $data;
    }

    public function getSuprimentos(Request $request)
    {
        try {
            $startDate = Carbon::createFromFormat('d/m/Y', $request['start'])->toDateString() . ' 00:00:00';
            $endDate = Carbon::createFromFormat('d/m/Y', $request['end'])->toDateString() . ' 23:59:59';
            $order = !isset($request['order']) ? 'DESC' : Str::upper($request['order']);
            $sort = $request['sort'] == '' ? 'dtData' : $request['sort'];
            $sangrias = $this->sangriaRepository
                ->with('operador')
                ->with('formaPagamento')
                ->with('authorizer')
                ->where('dtData', '>=', $startDate)
                ->where('dtData', '<=', $endDate)
                ->where('vrSangria', '<', 0)
                ->orderBy($sort, $order)
                ->get();

            return $sangrias;

        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function getSangrias(Request $request)
    {
        try {
            $startDate = Carbon::createFromFormat('d/m/Y', $request['start'])->toDateString() . ' 00:00:00';
            $endDate = Carbon::createFromFormat('d/m/Y', $request['end'])->toDateString() . ' 23:59:59';
            $order = !isset($request['order']) ? 'DESC' : Str::upper($request['order']);
            $sort = $request['sort'] == '' ? 'dtData' : $request['sort'];
            $sangrias = $this->sangriaRepository
                ->with('operador')
                ->with('formaPagamento')
                ->with('authorizer')
                ->where('dtData', '>=', $startDate)
                ->where('dtData', '<=', $endDate)
                ->where('vrSangria', '>', 0)
                ->orderBy($sort, $order)
                ->get();

            return $sangrias;

        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function getCommission(Request $request)
    {
        try {
            $result = $this->service->getCommissions($request->query());

            return response()->json($result);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getOrdersDelivery(Request $request) {
        try{
            $startDate = Carbon::createFromFormat('d/m/Y', $request['start']);
            $endDate = Carbon::createFromFormat('d/m/Y', $request['end']);
            $startHour = explode(':', $request['startHour'], -2);
            $startHour = $startHour[0];
            $endHour = explode(':', $request['endHour'], -2);
            $endHour = $endHour[0];
            $scheduled = $request['scheduled'] === 'false' ? 'AND flAgendarPedido = 0' : '';
            $customer = $request['customer'];
            $queryCustomer = $customer !== "null" ? "AND idCliente = $customer" : '';
            $engine = $request['engine'];
            $queryEngine = $engine !== "null" ? "AND engine = '$engine'" : '';

            $query = "
                select * from vw_pedidos_delivery
                WHERE flAtivo = 1 AND dtAbertura BETWEEN '$startDate' AND '$endDate'
                AND DATEPART(hour, dtAbertura) >= $startHour and DATEPART(hour, dtAbertura) <= $endHour
                $scheduled
                $queryCustomer
                $queryEngine
                ORDER BY dtAbertura, idCliente
            ";

            $res = DB::select($query);
            return response()->json($res);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
    public function getStockGroupByProduct(Request $request) {
        $startDate = Carbon::createFromFormat('d/m/Y', $request['start']);
        $endDate = Carbon::createFromFormat('d/m/Y', $request['end']);
        $query = "
            select p.stProduto, sum(i.nrQuantidade) as 'nrQuantidade', sum(i.vrValor) as 'vrValor', (sum(i.nrQuantidade) / sum(i.vrValor)) as custo, med.stMedida from est_Movimentacoes as m
            join est_ItensMovimentacao as i on i.idMovimentacao = m.idMovimentacao
            join prd_Produtos as p on p.idProduto = i.idProduto
            join prd_Medidas as med on p.idMedida = med.idMedida
            where m.dtMovimentacao between '$startDate' and '$endDate' and m.flEntrada = 1 and m.flAtivo = 1
            group by p.stProduto, med.stMedida     
        ";
        try {
            $res = DB::select($query);
            return response()->json($res);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }

    }
}
