<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUpdateCompany extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => 'required|email',
            'nome' => 'required|min:3|max:50',
            'cnpj' => 'required|unique:company,cnpj|min:11|max:14',
            // 'cep' => 'min:8|max:8',
            // 'rua' => 'min:3|max:50',

        ];
    }

    public function messages()
    {
        return [
            'cnpj.unique' => 'O CNPJ informado já está cadastrado',
        ];
    }
}
