<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Str;

class User extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
              "idOperador" => $this->idOperador,
              "stApelido" => trim($this->stApelido),
              "stEmail" => trim($this->stEmail),
              "stNome" => trim($this->stNome),
              "flAtivo" => $this->flAtivo,
              "stTelefone1" => trim($this->stTelefone1),
              "stTelefone2" => trim($this->stTelefone2),
              "stRG" => trim($this->stRG),
              "stEndereco" => trim($this->stEndereco),
              "stCargo" => trim($this->stCargo),
              "dtAdmissao" => Carbon::parse($this->dtAdmissao)->format('d/m/Y'),
              "nrPontos" => $this->nrPontos,
              "idPerfil" => $this->idPerfil,
              "stOBS" => trim($this->stOBS),
        ];
    }
}
