<?php

namespace App\Observers;

use App\Entities\Nati\ProdutoConfig;
use Illuminate\Support\Facades\Cache;

class ProdutoConfigObserver
{
    /**
     * Handle the config "created" event.
     *
     * @param  ProdutoConfig  $config
     * @return void
     */
    public function created(ProdutoConfig $config)
    {
        Cache::forget('produtoConfig');
    }

    /**
     * Handle the config "updated" event.
     *
     * @param  ProdutoConfig  $config
     * @return void
     */
    public function updated(ProdutoConfig $config)
    {
        Cache::forget('produtoConfig');
    }

    /**
     * Handle the config "deleted" event.
     *
     * @param  ProdutoConfig  $config
     * @return void
     */
    public function deleted(ProdutoConfig $config)
    {
        Cache::forget('produtoConfig');
    }

    /**
     * Handle the config "restored" event.
     *
     * @param  ProdutoConfig  $config
     * @return void
     */
    public function restored(ProdutoConfig $config)
    {
        //
    }

    /**
     * Handle the config "force deleted" event.
     *
     * @param  ProdutoConfig  $config
     * @return void
     */
    public function forceDeleted(ProdutoConfig $config)
    {
        //
    }
}
