<?php

namespace App\Repositories\Nati;

use App\Entities\Nati\StockItemsMovimentation;
use App\Validators\Nati\StockItemsMovimentationValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class StockItemsMovimentationRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class StockItemsMovimentationRepositoryEloquent extends BaseRepository implements StockItemsMovimentationRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return StockItemsMovimentation::class;
    }

    /**
     * Specify Validator class name
     *
     * @return mixed
     */
    public function validator()
    {
        return StockItemsMovimentationValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
