<?php

namespace App\Services\Nati;

use Illuminate\Support\Facades\Cache;
use App\Entities\Nati\Aliquota;
use App\Entities\Nati\Product;
use App\Repositories\Nati\AliquotaRepository;
use App\Validators\Nati\AliquotaValidator;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class AliquotaService
{
    private $repository;
    private $validator;


    public function __construct(AliquotaRepository $repository, AliquotaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function getById($id)
    {

        return $this->repository->withCount('produtos')->find($id);
    }

    public function all()
    {
        if (Cache::has('ListaAliquotas')) {
            return Cache::get('ListaAliquotas');
        } else {
            $response = $this->repository->withCount('produtos')->findWhere(['flAtivo' => true]);
            Cache::put('ListaAliquotas', $response, 1440);
            return $response;
        }
    }

    public function create($request)
    {
        $request['idAliquota'] = $this->getNextId();
        $request['vrAliquota'] = 0;
//        $aliquota = [
//            "idAliquota"        => $this->getNextId(),
//            "stAliquota"        => $request['stAliquota'],
//            "vrAliquota"        => 0,
//            "flAtivo"           => true,
//            "dtAlteracao"       => Carbon::now(),
//            "Codigo"            => $request['code'],
//            "CstIcms"           => $request['cst_icms'],
//            "CstPis"            => $request['cst_pis'],
//            "CstCofins"         => $request['cst_cofins'],
//            "CfopEntrada"       => $request['cfop_entrada'],
//            "CfopSaida"         => $request['cfop_saida'],
//            "Iva"               => (empty($request['iva'])) ? '0' : $request['iva'],
//            "AliquotaIcms"      => (empty($request['aliquota_icms'])) ? '0' : $request['aliquota_icms'],
//            "AliquotaCofins"    => $request['aliquota_cofins'],
//            "AliquotaPis"       => $request['aliquota_pis'],
//        ];

        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($request);
    }

    public function update($request, $id)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        $request['dtAlteracao'] = Carbon::now();
        return $this->repository->update($request, $id);
    }

    public function delete($id)
    {
        return $this->repository->update(['flAtivo' => false, 'dtAlteracao' => Carbon::now()], $id);
    }

    private function getNextId()
    {
        return $aliquota = Aliquota::max('idAliquota') + 1;
    }

    public function transfer($idAliquota, $idAliquotaNew)
    {
        $produto = Product::query()->where('idAliquota', '=', $idAliquota)->update(['idAliquota' => $idAliquotaNew]);

        $this->repository->update(['flAtivo' => false], $idAliquota);

        return $produto;
    }

    public function getOrCreate($data)
    {
        $aliq = $this->repository->findWhere([
            "CstIcms" => $data['CST-ICMS'],
            "CstPis" => $data['CST-PIS'],
            "CstCofins" => $data['CST-COFINS'],
            "CfopSaida" => $data['CFOP'],
            "AliquotaIcms" => str_replace(',','.', $data['ALIQ-ICMS']),
            "AliquotaCofins" => str_replace(',','.', $data['ALIQ-COFINS']),
            "AliquotaPis" => str_replace(',','.', $data['ALIQ-PIS']),
        ])->first();
        if ($aliq) {
            return $aliq;
        } else {
            return $this->create([
                "CstIcms" => $data['CST-ICMS'],
                "CstPis" => $data['CST-PIS'],
                "CstCofins" => $data['CST-COFINS'],
                "CfopSaida" => $data['CFOP'],
                "CfopEntrada" => $data['CFOP'],
                "AliquotaIcms" => str_replace(',','.', $data['ALIQ-ICMS']),
                "AliquotaCofins" => str_replace(',','.', $data['ALIQ-COFINS']),
                "AliquotaPis" => str_replace(',','.', $data['ALIQ-PIS']),
                "stAliquota" => $data['CFOP'] . '-' . $data['CST-ICMS'],
                "vrAliquota" => 0,
                "flAtivo" => true,
                "dtAlteracao" => Carbon::now(),
                "Codigo" => $data['CFOP'] . '-' . $data['CST-ICMS'],
                "Iva" => 0,

            ]);
        }
    }

}
