<?php


namespace App\Services\Nati;


use App\Entities\Nati\FichaTecnica;
use App\Repositories\Nati\FichaTecnicaRepository;
use App\Validators\Nati\FichaTecnicaValidator;
use Carbon\Carbon;

class FichaTecnicaService
{
    private $repository;
    private $validator;


    public function __construct(FichaTecnicaRepository $repository, FichaTecnicaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function insert($request)
    {
        $this->deleteAPI($request['printer'], $request['sector'], $request['terminals']);

        $parametersMaxLength = 2000;
        $parametersOnRecord = 5;

        $records = array();

        foreach ($request['terminals'] as $terminal) {
            foreach ($request['ids'] as $id) {
                $record = [
                    'idPrint' => $request['printer'],
                    'idProduto' => $id,
                    'idMicroterminal' => $terminal,
                    'idSetor' => $request['sector'],
                    'dtAlteracao' => Carbon::now()->toTimeString()
                ];
                array_push($records, $record);
            }
        }

        if (count($records) * $parametersOnRecord > $parametersMaxLength) {
            $partitionsCount = $parametersMaxLength / $parametersOnRecord;
            $chunk = array_chunk($records, $partitionsCount);
            foreach ($chunk as $partition) {
                FichaTecnica::insert($partition);
            }
        } else {
            FichaTecnica::insert($records);
        }

        return true;
    }

    public function delete($id)
    {
        return $this->repository->delete($id);
    }

    public function deleteByMicroTerminal($microTerminalId)
    {
        return $this->repository->deleteWhere(['idMicroterminal' => $microTerminalId]);
    }

    public function deleteByPrinter($printerId)
    {
        return $this->repository->deleteWhere(['idPrint' => $printerId]);
    }

    private function deleteAPI($printer, $sector, $terminals)
    {
        return FichaTecnica::where(['idPrint' => $printer, 'idSetor' => $sector])->whereIn('idMicroterminal', $terminals)->delete();
    }
}
