<?php

namespace App\Services;

use App\Entities\Permission;
use App\Entities\Profile;
use App\Entities\User;
use App\Repositories\ProfileRepository;
use App\Validators\ProfileValidator;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;

class ProfileService extends Service
{
    private $repository;
    private $validator;

    public function __construct(ProfileRepository $repository, ProfileValidator $validator)
    {
        $this->validator = $validator;
        $this->repository = $repository;
    }

    public function get($request)
    {
        if (Cache::tags(['ListaProfile'])->has('all')) {
            return Cache::tags(['ListaProfile'])->get('all');
        } else {
            $response = $this->repository->withCount('usuarios')->all();
            Cache::tags(['ListaProfile'])->put('all', $response, 1440);
            return $response;
        }
    }

    public function getPermissions()
    {
        if (Cache::tags(['ListaPermissoes'])->has('all')) {
            return Cache::tags(['ListaPermissoes'])->get('all');
        } else {
            $data['nati'] = Permission::where('idCategoria', 1)->orderBy('stDescricao')->get();
            $data['caixa'] = Permission::where('idCategoria', 2)->orderBy('stDescricao')->get();
            $data['microterminal'] = Permission::where('idCategoria', 3)->orderBy('stDescricao')->get();
            $data['delivery'] = Permission::where('idCategoria', 4)->orderBy('stDescricao')->get();
            $data['financeiro'] = Permission::where('idCategoria', 5)->orderBy('stDescricao')->get();

            Cache::tags(['ListaPermissoes'])->put('all', $data, 1440);
            return $data;
        }
    }

    public function getById($id)
    {
        return $this->repository->withCount('usuarios')->find($id);
    }

    public function insert($request)
    {
        $request['idPerfil'] = $this->nextId();
        $data = array_map('strtoupper', $request);

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($data);
    }

    public function update($request, $id)
    {
        $request['updated_at'] = $this->getDate();
        $data = array_map('strtoupper', $request);

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        $this->repository->update($data, $id);

        /** INCLUIR PERMISSOES LEGADO */

        $ids = User::where('idPerfil', $id)->get()->map(function ($item) {
            return intval($item->idOperador);
        })->toArray();

        if(count($ids) > 0) {
            //IDS REFERENTES AO PERFIL ATUALIZADO
            $delIds = json_encode($ids);
            $delIds = "(" . substr($delIds, 1, -1) . ")";

            //EXCLUINDO VALORES ANTIGOS
            DB::delete("DELETE FROM op_Acessos WHERE idOperador IN $delIds");

            $inserts = [""];
            $cont = 0;
            $i = 0;
            $permissions = json_decode($request['stIds']);

            //MONTAGEM DA QUERY DE INSERÇÃO
            foreach ($ids as $id) {
                foreach ($permissions as $permission) {
                    if ($cont < 999) {
                        $inserts[$i] .= "($id, $permission, GETDATE()),";
                        $cont++;
                    } else {
                        array_push($inserts, "");
                        $inserts[$i++] .= "($id, $permission, GETDATE()),";
                        $cont = 0;
                    }
                }
            }

            //INSERÇÃO A CADA 1000 REGISTROS
            foreach ($inserts as $insert) {
                $values = substr($insert, 0, -1);
                DB::insert('INSERT INTO op_Acessos VALUES ' . $values);
            }

            /** FIM INCLUIR PERMISSOES LEGADO */
        }
        return true;
    }

    public function delete($id)
    {
        return $this->repository->delete($id);
    }

    private function nextId()
    {
        return Profile::max('idPerfil') + 1;
    }
}
