<?php


namespace App\Services\Reports;

use App\Entities\Nati\Reports\RelatorioFechamentoCaixa;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ReportFechamentoCaixaService
{
    public function getReport ($request)
    {
        $report['totalItems'] = 0;
        $report['itemsCancelados'] = 0;
        $report['totalVendas'] = 0;
        $report['vendasCanceladas'] = 0;
        $report['valorAbertura'] = 0;
        $report['totalClientes'] = 0;
        $report['valorVendasCanceladas'] = 0;
        $report['valorDescontos'] = 0;
        $report['valorAcrescimos'] = 0;
        $report['valorContraValesEmitidos'] = 0;
        $report['valorContraValesRecebidos'] = 0;
        $report['valorVouchersEmitidos'] = 0;
        $report['valorVouchersRecebidos'] = 0;
        $report['pagamentoContaAssinada'] = 0;
        $report['depositoContaAssinada'] = 0;
        $report['valorRepique'] = 0;
        $report['despesas'] = [];
        $report['pagamentos'] = [];
        $report['sangrias'] = [];
        $ids = $this->getOpenings($request['startDate'], $request['endDate'], $request['idUser']);

        if($ids) {
            $report['totalItems'] = $this->getAmountItems($ids);
            $report['itemsCancelados'] = $this->getCancelledItems($ids);
            $report['totalVendas'] = $this->getAmountSales($ids);
            $report['vendasCanceladas'] = $this->getCancelledSales($ids);
            $report['valorAbertura'] = $this->getOpeningValue($ids);
            $report['totalClientes'] = $this->getAmountCustomers($ids);
            $report['valorVendasCanceladas'] = $this->getAmountCancelledSales($ids);
            $report['valorDescontos'] = $this->getAmountDiscounts($ids);
            $report['valorAcrescimos'] = $this->getAmountAdditions($ids);
            $report['valorContraValesEmitidos'] = $this->getAmountCreditCouponIssued($ids);
            $report['valorContraValesRecebidos'] = $this->getAmountCreditCouponReceived($ids);
            $report['valorVouchersEmitidos'] = $this->getAmountVouchersIssued($ids);
            $report['valorVouchersRecebidos'] = $this->getAmountVouchersReceived($ids);
            $report['pagamentoContaAssinada'] = $this->getSignedAccountPayment($ids);
            $report['depositoContaAssinada'] = $this->getSignedAccountDeposit($ids);
            $report['estornoContaAssinada'] = $this->getSignedAccountReversal($ids);
            $report['valorRepique'] = $this->getAmountPeal($ids);
            $report['despesas'] = $this->getExpenses($ids);
            $report['pagamentos'] = $this->getPayments($ids);
            $report['sangrias'] = $this->getSangrias($ids);
        }
        return $report;
    }

    private function getOpenings($startDate, $endDate, $idUser = null)
    {
        $startDate = Carbon::createFromFormat('d/m/Y', $startDate)->toDateString() . ' 00:00:00';
        $endDate = Carbon::createFromFormat('d/m/Y', $endDate)->toDateString() . ' 23:59:59';
        if(!$idUser) {
            $result =  DB::select("
                select idAbertura from cx_Gerenciador
                where flAberto = 0
                and flConferencia = 1
                and dtAbertura between '$startDate' and '$endDate'
            ");
        } else {
            $result =  DB::select("
                select idAbertura from cx_Gerenciador
                where flAberto = 0
                and flConferencia = 1
                and dtAbertura between '$startDate' and '$endDate'
                and idOperador = $idUser
            ");
        }
        $ids = [];
        foreach($result as $index => $value) {
            array_push($ids, $value->idAbertura);
        }
        $ids = implode(',', $ids);
        return $ids;
    }

    private function getAmountItems($idAbertura)
    {
        $amountItems = DB::select("select count(*) as total from cx_itens where flAtivo = 1 and idAbertura in ($idAbertura)");
        return floatval($amountItems[0]->total ? $amountItems[0]->total : 0);
    }

    private function getCancelledItems($idAbertura)
    {
        $cancelleds = DB::select("select count(*) as total from cx_itens where flAtivo = 0 and idAbertura in ($idAbertura)");
        return floatval($cancelleds[0]->total ? $cancelleds[0]->total : 0);
    }

    private function getAmountSales($idAbertura)
    {
        $amount = DB::select("select count(*) as total from cx_vendas where flAtivo = 1 and idAbertura in ($idAbertura)");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getCancelledSales($idAbertura)
    {
        $cancelleds = DB::select("select count(*) as total from cx_vendas where flAtivo = 0 and idAbertura in ($idAbertura)");
        return floatval($cancelleds[0]->total ? $cancelleds[0]->total : 0);
    }

    private function getOpeningValue($idAbertura)
    {
        $value = DB::select("select sum(vrAbertura) as total from cx_gerenciador where idAbertura in ($idAbertura)");
        return floatval($value[0]->total ? $value[0]->total : 0);
    }

    private function getAmountCustomers($idAbertura)
    {
        $amount = DB::select("select sum(nrClientes) as total from cx_Gerenciador where idAbertura in ($idAbertura)");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getAmountCancelledSales($idAbertura)
    {
        $amount = DB::select("select sum(vrTotal) as total from cx_itens where flAtivo = 0 and idAbertura in ($idAbertura)");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getAmountDiscounts($idAbertura)
    {
        $amount = DB::select("select sum(vrDesconto) as desconto from cx_vendas where flAtivo = 1 and idAbertura in ($idAbertura)");
        return floatval($amount[0]->desconto ? $amount[0]->desconto : 0);
    }

    private function getAmountAdditions($idAbertura)
    {
        $amount = DB::select("select sum(vrAcrescimo) as acrescimo from cx_vendas where flAtivo = 1 and idAbertura in ($idAbertura)");
        return floatval($amount[0]->acrescimo ? $amount[0]->acrescimo : 0);
    }

    private function getAmountCreditCouponIssued($idAbertura)
    {
        $amount = DB::select("
            SELECT SUM(p.vrFormaPagamento * (-1)) as total " .
            "FROM cx_FormasPagamento f " .
            "INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma " .
            "INNER JOIN cx_FichaPagamentos p ON f.idFormaPagamento = p.idFormaPagamento " .
            "WHERE p.flAtivo = '1' AND p.idAbertura in ($idAbertura) AND t.idTipoForma = 6
        ");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getAmountCreditCouponReceived($idAbertura)
    {
        $amount = DB::select("
            SELECT SUM(p.vrFormaPagamento) as total " .
            "FROM cx_FormasPagamento f " .
            "INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma " .
            "INNER JOIN cx_FichaPagamentos p ON f.idFormaPagamento = p.idFormaPagamento " .
            "WHERE p.flAtivo = '1' AND p.idAbertura in ($idAbertura) AND t.idTipoForma = 7
        ");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getAmountVouchersIssued($idAbertura)
    {
        $amount = DB::select("SELECT SUM(vrVaucher)as total FROM cx_vaucher WHERE flAtivo = 1 AND idAbertura in ($idAbertura)");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getAmountVouchersReceived($idAbertura)
    {
        $idForma = DB::select("SELECT idFormaPagamento FROM cx_FormasPagamento WHERE stFormaPagamento = 'VOUCHER' OR stFormaPagamento = 'VOUCHERS'");
        if($idForma) {
            $idForma = intval($idForma[0]->idFormaPagamento, 10);
            $amount = DB::select("
            SELECT SUM(p.vrFormaPagamento) as total
            FROM cx_FormasPagamento f
            INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
            INNER JOIN cx_FichaPagamentos p ON f.idFormaPagamento = p.idFormaPagamento
            WHERE p.flAtivo = 1 AND p.idAbertura in ($idAbertura) AND p.idFormaPagamento = $idForma;
            ");
            return floatval($amount[0]->total ? $amount[0]->total : 0);
        }
        return 0;
    }

    private function getSignedAccountPayment($idAbertura)
    {
        $amount = DB::select("
            SELECT SUM(E.vrTotal+E.vrDesconto) as total
            FROM cli_Extrato E
            INNER JOIN cx_Gerenciador G ON E.idAbertura = G.idAbertura
            WHERE G.idAbertura in ($idAbertura) AND E.flAtivo = 1
        ");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getSignedAccountDeposit($idAbertura)
    {
        $amount = DB::select("
            SELECT SUM(vrPagamento) as total FROM cli_Pagamento WHERE flAtivo = 1 AND idAbertura in ($idAbertura) AND vrPagamento > 0
        ");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getSignedAccountReversal($idAbertura)
    {
        $amount = DB::select("
            SELECT SUM(vrPagamento) as total FROM cli_Pagamento WHERE flAtivo = 1 AND idAbertura in ($idAbertura) AND vrPagamento < 0
        ");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getAmountPeal($idAbertura)
    {
        $amount = DB::select("
            SELECT SUM(vrRepique) as total
            FROM cx_Repique
            WHERE flAtivo = 1 AND idAbertura in ($idAbertura)
        ");
        return floatval($amount[0]->total ? $amount[0]->total : 0);
    }

    private function getExpenses($idAbertura)
    {
        $expenses = DB::select("
        SELECT cd.dtData, cd.vrDespesa, fp.stFormaPagamento, cd.stDescricao
        FROM cx_Despesas cd
        INNER JOIN cx_FormasPagamento fp ON cd.idFormaPagamento = fp.idFormaPagamento
        INNER JOIN cx_Gerenciador gr ON cd.idAbertura = gr.idAbertura
        WHERE cd.flAtivo = 1 AND cd.idAbertura IN ($idAbertura)
        ");
        $expenses = json_decode(json_encode($expenses), true);
        return $expenses;
    }

    private function getSangrias($idAbertura)
    {
        $sangrias = DB::select("
            SELECT * from cx_sangrias
            where flativo = 1 and idAbertura in ($idAbertura) and vrSangria >= 0;
        ");
        return json_decode(json_encode($sangrias), true);
    }

    private function getPayments($idAbertura)
    {
        $payments = DB::select("
            SELECT SUM(g.vrPagamento) as vrPagamento, SUM(g.vrPagamentoMicro) as vrPagamentoMicro,
            CASE
            WHEN (SELECT TOP(1) SUM(vrSangria) FROM cx_Sangrias WHERE idAbertura = g.idAbertura AND idFormaPagamento = f.idFormaPagamento) IS NULL THEN 0
            ELSE (SELECT TOP(1) SUM(vrSangria) FROM cx_Sangrias WHERE idAbertura = g.idAbertura AND idFormaPagamento = f.idFormaPagamento)
            END as vrSangria,
            f.idFormaPagamento, f.stFormaPagamento, f.vrTaxa
            FROM cx_GerenciadorDetalhes g
            INNER JOIN cx_FormasPagamento f
            ON g.idFormaPagamento = f.idFormaPagamento
            INNER JOIN cx_TiposFormaPagamento t
            ON t.idTipoForma = f.idTipo
            WHERE g.idAbertura IN ($idAbertura) AND t.idTipoForma NOT IN ('6', '7', '9', '12', '13', '14', '16', '17')
            GROUP BY  f.idFormaPagamento, f.stFormaPagamento, f.vrTaxa, idAbertura
        ");
        $payments = json_decode(json_encode($payments), true);
        return $payments;
    }
}
