<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOpOperadoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('op_Operadores')) {
            Schema::create('op_Operadores', function (Blueprint $table) {

                $table->integer('idOperador', false, true);
                $table->string('stApelido', 32)->nullable(true);
                $table->string('stSenha', 20)->nullable(true);
                $table->decimal('nrAcessos',18, 0)->default(0)->nullable(false);
                $table->string('stEmail',50)->nullable(true);
                $table->string('stNome',50)->nullable(false);
                $table->dateTime('dtUltimoAcesso')->nullable(true);
                $table->boolean('flAtivo')->default(true);
                $table->string('stTelefone1',20)->nullable(true);
                $table->string('stTelefone2',20)->nullable(true);
                $table->string('stRG',15)->nullable(true);
                $table->string('stEndereco',70)->nullable(true);
                $table->string('stCargo',30)->nullable(true);
                $table->datetime('dtAdmissao')->nullable(true);
                $table->string('stCartao',16)->nullable(false)->default(0.0);
                $table->text('binDigital')->nullable(true);
                $table->integer('nrPontos')->nullable(false)->default(0);
                $table->text('stDigital')->nullable(true);
                $table->dateTime('dtAlteracao')->nullable(false);
                $table->integer('idOperadorIntegracao')->nullable(true);
                $table->string('stIdentFid',16)->nullable(true);
                $table->integer('idPerfil')->nullable(false);;

                $table->primary('idOperador');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('op_Operadores');

    }
}
