<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinContasReceberTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_ContasReceber')) {
            Schema::create('fin_ContasReceber', function (Blueprint $table) {
                $table->unsignedInteger('idContasReceber');
                $table->unsignedInteger('idCliente');
                $table->unsignedInteger('idTipoConta');
                $table->dateTime('dtLancamento');
                $table->dateTime('dtVencimento');
                $table->dateTime('dtRecebimento');
                $table->unsignedInteger('nrParcela');
                $table->unsignedInteger('nrTotalParcelas');
                $table->decimal('vrDocumento', 9, 2);
                $table->decimal('vrRecebido', 9, 2);
                $table->decimal('vrJuros', 9, 2);
                $table->boolean('flJuros');
                $table->boolean('flRecebido');
                $table->boolean('flAtivo');
                $table->string('stOperador', 20);
                $table->string('stObservacao', 255);
                $table->string('stDocumento', 255);
                $table->char('stTipoBaixa', 1)->default('I');
                $table->char('stTipoJuros', 1)->default('P');
                $table->unsignedInteger('idFormaPagamento');
                $table->string('stObservacaoBaixa', 255);
                $table->decimal('vrDescontoLancamento', 9, 2);
                $table->unsignedInteger('idContaBancaria')->default(0);
                $table->unsignedInteger('idConta')->default(0);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
                $table->unsignedInteger('idTipoPagamento')->default(1);
                $table->char('stFormato', 1);


            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_ContasReceber');
    }
}
