<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class V63 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

    }

    public function alterClientesTable(){
        if (Schema::hasColumn('dlv_Clientes', 'flNutricional')){
            Schema::table('dlv_Clientes', function(Blueprint $table){
               $table->boolean('flNutricional')->default(false)->nullable()->change();
               $table->boolean('flFuncionario')->default(false)->nullable()->change();
               $table->boolean('flAtivo')->default(true)->change();
               $table->decimal('vrEntrega')->default(0)->change();
               $table->decimal('vrSaldo')->default(0)->change();
               $table->dateTime('dtCadastro')->default(\Carbon\Carbon::now())->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
