<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtImpressaoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_Impressao')) {

            DB::statement('CREATE TABLE [dbo].[mt_Impressao](
                  [idImpressao] [int] NOT NULL,
                  [idPrint] [smallint] NOT NULL,
                  [stImpressao] [int] NOT NULL,
                  [flAtivo] [bit] NOT NULL,
                  [idStatus] [int] NOT NULL,
                  [stRetorno] [nvarchar](30) NOT NULL,
                  [flConcluido] [bit] NOT NULL,
                  [stTerminal] [nvarchar](25) NOT NULL,
                  [stAtendente] [nvarchar](12) NOT NULL,
                  [dtData] [datetime] NOT NULL,
                  [dtClonclusao] [datetime] NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL,
                  CONSTRAINT [PK_mt_Impressao] PRIMARY KEY CLUSTERED
                    (
                      [idImpressao] ASC,
                      [idPrint] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Impressao');

    }
}
