<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNatLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('nat_Log')) {

            DB::statement('CREATE TABLE [dbo].[nat_Log](
                  [idLog] [bigint] NOT NULL,
                  [stOperador] [nvarchar](20) NOT NULL,
                  [dtData] [smalldatetime] NOT NULL,
                  [stArea] [nvarchar](20) NOT NULL,
                  [stDescricao] [nvarchar](255) NOT NULL,
                  [stSoftware] [nvarchar](20) NOT NULL CONSTRAINT [DF_nat_Log_stSoftware]  DEFAULT (N\'NATI\'),
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_nat_Log_dtAlteracao]  DEFAULT (getdate())
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nat_Log');

    }
}
