<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;


class PrdAliquotasSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (!DB::table('prd_Aliquotas')->count()) {

            $data = [
                [
                    'idAliquota' => 1,
                    'stAliquota' => 'I',
                    'vrAliquota' => 0.00,
                    'flAtivo' => 1,
                    'dtAlteracao' => Carbon::now(),
                    'Codigo' => '5102-006',
                    'CstIcms' => 40,
                    'CstPis' => 01,
                    'CstCofins' => 01,
                    'CfopEntrada' => 1202,
                    'CfopSaida' => 5102,
                    'Iva' => 0.0000,
                    'AliquotaIcms' => 0.0000,
                    'AliquotaCofins' => 3.0000,
                    'AliquotaPis' => 0.6500,
                ]
            ];

            DB::table('prd_Aliquotas')->insert($data);
        }
    }
}
