<?php
require_once "../model/grupoDao.class.php";
require_once "../model/centroDeCustoDao.class.php";
require_once "../model/subGrupoDao.class.php";
require_once "../model/contaDao.class.php";
require_once "../model/baixaAutomaticaDao.class.php";
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Classe de servi�o para gerenciar as opera��es de Configuração.
 *
 * @author kid
 */
class ConfiguracaoService {
    
    //---------- [VARI�VEIS] ---------------------------------------------------
    
    private $grupoDao;
    private $centroDeCustoDao;
    private $subGrupoDao;
    private $contaDao;
    private $baixaAutomaticaDao;
    
    //---------- [CONSTRUTORES] ------------------------------------------------
    
    /**
     * Construtor default.
     */
    public function __construct() {
        $this->grupoDao = new GrupoDao();
        $this->centroDeCustoDao = new CentroDeCustoDao();
        $this->subGrupoDao = new SubGrupoDao();
        $this->contaDao = new ContaDao();
        $this->baixaAutomaticaDao = new BaixaAutomaticaDao();
    }

    //---------- [M�TODOS] -----------------------------------------------------
    
    /**
     * M�todo para listar todos os Grupos.
     * 
     * @return Uma lista com todos os objetos de Grupos cadastrados.
     */
    public function listarGruposEntrada() {
        return $this->grupoDao->listarGruposEntrada();
    }
    
    /**
     * M�todo para listar todos os Grupos.
     * 
     * @return Uma lista com todos os objetos de Grupos cadastrados.
     */
    public function listarGruposSaida() {
        return $this->grupoDao->listarGruposSaida();
    }
    
    /**
     * M�todo para listar todos os Centros de Custos.
     * 
     * @return Uma lista com todos os objetos de Centro de Custo cadastrados.
     */
    public function listarCentroDeCustos() {
        return $this->centroDeCustoDao->listar();
    }
    
    /**
     * M�todo para buscar todos os Sub-Grupos de um determinado Grupo.
     * 
     * @param int $grupoId O id do Grupo do qual se deseja adquirir os 
     *      Sub-Grupos.
     * 
     * @return Uma lista com todos os objetos de Sub-Grupo de um determinado 
     *      Grupo. 
     */
    public function buscarSubGrupoPorGrupo($grupoId = null) {
        if ($grupoId != null ) {
            $subGrupos = $this->subGrupoDao->buscarPorGrupo($grupoId);
            return $subGrupos;
        }
    }
    
    /**
     * M�todo para buscar todas as Contas de de um determinado Sub-Grupo.
     * 
     * @param int $subGrupoId O id do Sub-Grupo do qual se deseja adquirir as 
     *      Contas.
     * 
     * @return Uma lista com todos os objetos de Conta de um determinado 
     *      Sub-Grupo.
     */
    public function buscarContaPorSubGrupo($subGrupoId = null) {
        if ($subGrupoId != null) {
            $contas = $this->contaDao->buscarContaPorSubGrupo($subGrupoId);
            return $contas;
        }
    }
    
    /**
     * M�todo de servi�o por inserir ou alterar
     * @param type $dados
     * @param type $condicao
     */
    public function registrarBaixaAutomatica($dados = null) {
         if ($dados != null) {
            $configuracao = $this->buscarUltimaConfiguracao();
            
            if ($configuracao) {
                $this->baixaAutomaticaDao->alterar($dados, $configuracao->idConfig);
            } else {
                $this->baixaAutomaticaDao->inserir($dados);
            }
        }
    }
    
    public function buscarUltimaConfiguracao() {
        return $this->baixaAutomaticaDao->buscarUltimaConfiguracao();
    }
    
    public function apagarBaixaAutomatica() {
        $this->baixaAutomaticaDao->excluir();
    }
}
?>
