<?php
require_once "../functions.php";

db_conn();

if (autorization(7) == false)
{
	?>
	<SCRIPT>
		document.location = "../?sec=erro&sub=2";
	</SCRIPT>
	<?
	die;
}

$idAbertura = htmlspecialchars($_GET['id'], ENT_QUOTES);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Detalhes de Outras Despesas</title>
	<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
	<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
	<link href="resources/css/toastr.css" rel="stylesheet"/>
	<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
	<link href="resources/css/custom.css" rel="stylesheet"/>
</head>
<body>
	<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
		<caption class="table-caption"><b>Detalhes de Outras Despesas</b></caption>
		<thead>
			<tr>
				<td class="tdStyle" width="35%"><b>Despesa</b></td>
				<td class="tdStyle" width="20%"><b>Data</b></td>
				<td class="tdStyle" width="25%"><b>Forma</b></td>
				<td class="tdStyle" width="20%"><b>Valor</b></td>
			</tr>
		</thead>
		<?
		if (is_numeric($idAbertura))
		{
			$sql = "SELECT cd.dtData, cd.vrDespesa, fp.stFormaPagamento, cd.stDescricao ".
			"FROM cx_Despesas cd ".
			"INNER JOIN cx_FormasPagamento fp ON cd.idFormaPagamento = fp.idFormaPagamento ".
			"INNER JOIN cx_Gerenciador gr ON cd.idAbertura = gr.idAbertura ".
			"WHERE cd.flAtivo = '1' AND cd.idAbertura = '$idAbertura'";
		}
		else
		{
			$sql = "SELECT cd.dtData, cd.vrDespesa, fp.stFormaPagamento, cd.stDescricao ".
			"FROM cx_Despesas cd ".
			"INNER JOIN cx_FormasPagamento fp ON cd.idFormaPagamento = fp.idFormaPagamento ".
			"INNER JOIN cx_Gerenciador gr ON cd.idAbertura = gr.idAbertura ".
			"WHERE cd.flAtivo = '1' AND gr.flAberto = '1'";
		}

		$res = mssql_query($sql);

		while ($arr = mssql_fetch_array($res))
		{
			$dtData = strtotime($arr['dtData']);
			$dtData = date("d/m/y H:i", $dtData);

			?>
			<tr>
				<td class="tdStyle"><?php echo $arr['stDescricao']?></td>
				<td class="tdStyle"><?php echo $dtData?></td>
				<td class="tdStyle"><?php echo $arr['stFormaPagamento']?></td>
				<td class="tdStyle" align="right">R$ <?php echo $arr['vrDespesa']?></td>
			</tr>
			<?
		}

		if (is_numeric($idAbertura))
		{
			$sql = "SELECT SUM(vrDespesa) as vrDespesa FROM cx_Despesas WHERE flAtivo = '1' AND idAbertura = '$idAbertura'";
		}
		else
		{
			$sql = "SELECT SUM(d.vrDespesa) as vrDespesa FROM cx_Despesas d ".
			"INNER JOIN cx_Gerenciador g ON d.idAbertura = g.idAbertura ".
			"WHERE d.flAtivo = '1' AND g.flAberto = '1'";
		}

		$res = mssql_query($sql);
		$arr = mssql_fetch_array($res);
		?>
		<tr>
			<td class="tdStyle" colspan="3"><b>Valor Total:</b></td>
			<td class="tdStyle" align="right"><b>R$ <?php echo  ($arr['vrDespesa'] ? $arr['vrDespesa'] : "0.00") ?></b></td>
		</tr>
	</table>
</body>
</html>
