<?php
header('Content-type: application/json');

require_once "../../../functions.php";
db_conn();

$VAR_cx_Itens = "cx_FichaRecebimentos";
$VAR_cx_Vendas = "cx_Itens";
$VAR_cx_FichaPagamentos = "cx_Vendas";

if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'getProductById':
            getProductById($_POST['status'], $_POST['id']);
            break;
        case 'getFornecedoresByCodigoProduto':
            getFornecedoresByCodigoProduto($_POST['idCodigo']);
            break;
        case 'desativarProduto':
            desativarProduto($_POST['idCodigo']);
            break;
        case 'reativarProduto':
            reativarProduto($_POST['idProduto']);
            break;
        case 'excluirProduto':
            excluirProduto($_POST['idCodigo']);
            break;
        case 'getAliquota':
            getAliquota();
            break;
        case 'getTipoSped':
            getTipoSped();
            break;
        case 'getSubCategoriaByCategoria':
            getSubCategoriaByCategoria($_POST['idCategoria']);
            break;
        case 'checkCodigoProduto':
            checkCodigoProduto($_POST['codigoProduto']);
            break;
        case 'getMaxCodigo':
            getMaxCodigo();
            break;
        case 'getEstoquesOrigem':
            getEstoquesOrigem();
            break;
        case 'cadastrarProduto':
            cadastrarProduto($_REQUEST);
            break;
        case 'editarProduto':
            editarProduto($_REQUEST);
            break;
        case 'getSaldoEditProduto':
            getSaldoEditProduto($_POST['idProduto']);
            break;
        case 'insertItemAdicional':
            insertItemAdicional($_POST['idProdutoPrincipal'], $_POST['idProduto'], $_POST['qtd'], $_POST['custo']);
            break;
        case 'removeItemAdicional':
            removeItemAdicional($_POST['idProdutoPrincipal'], $_POST['idProduto']);
            break;
        case 'getItemAdicionalProduto':
            getItemAdicionalProduto($_POST['idProduto']);
            break;
        case 'popularNCM':
            popularNCM($_POST['texto']);
            break;
        case 'getConfig':
            getConfig();
            break;
        case 'salvarConfig':
            saveConfig($_POST['flIdProduto'], $_POST['flDtAlteracao'], $_POST['flCodigo'], $_POST['flDesc'], $_POST['flDescAbr'], $_POST['flCategoria'], $_POST['flSubCategoria'], $_POST['flMedidaVenda'], $_POST['flMedidaCompra'], $_POST['flSetor'], $_POST['flVrCompra'], $_POST['flVrVenda'], $_POST['flAliquota'], $_POST['flNCM']);
            break;
        case 'getProductByProductId':
            getProductByProductId($_POST['status'], $_POST['id']);
            break;
        case 'getConfigModulos':
            getConfigModulos();
            break;
        case 'obterCest':
            obterCest($_POST['nrNcm']);
            break;
    }
}


function getProductById($status, $id)
{
    if ($status >= 1) {
        $sql = "SELECT p.*, (m.flFracionado) as flFracionado, (m.stMedida) as stMedidaVenda, 
        (m.idMedida) as idMedidaVenda, (mc.stMedida) as stMedidaCompra, (mc.idMedida) as idMedidaCompra,
         c.stCategoria, s.stSetor, a.stAliquota, l.stLocalizacao, cod.idCodigo FROM prd_Produtos p
		INNER JOIN prd_Codigos cod ON p.idProduto = cod.idProduto
		LEFT JOIN prd_Medidas m ON p.idMedida = m.idMedida
		LEFT JOIN prd_Medidas mc ON p.idMedidaCompra = mc.idMedida
		LEFT JOIN prd_Categorias c ON p.idCategoria = c.idCategoria
		LEFT JOIN prd_Setores s ON p.idSetor = s.idSetor
		LEFT JOIN prd_Aliquotas a ON p.idAliquota = a.idAliquota
		LEFT JOIN prd_Localizacoes l ON p.idLocalizacao = l.idLocalizacao
		WHERE cod.idCodigo = '$id'";

        $res = mssql_query($sql);
        $arr = mssql_fetch_assoc($res);

        $sql = "UPDATE prd_Categorias SET flAtivo = 1 WHERE idCategoria = " . $arr['idCategoria'];
        mssql_query($sql);
        $sql = "UPDATE prd_Aliquotas SET flAtivo = 1 WHERE idAliquota = " . $arr['idAliquota'];
        mssql_query($sql);
        $sql = "UPDATE prd_Localizacoes SET flAtivo = 1 WHERE idLocalizacao = " . $arr['idLocalizacao'];
        mssql_query($sql);
        $sql = "UPDATE prd_Setores SET flAtivo = 1 WHERE idSetor = " . $arr['idSetor'];
        mssql_query($sql);
        $sql = "UPDATE prd_Medidas SET flAtivo = 1 WHERE idMedida = " . $arr['idMedida'];
        mssql_query($sql);
        $sql = "UPDATE prd_Medidas SET flAtivo = 1 WHERE idMedida = " . $arr['idMedidaCompra'];
        mssql_query($sql);

        $sql = "SELECT * FROM prd_SubCategorias WHERE idCategoria = " . $arr['idCategoria'] . " AND idSubCategoria = " . $arr['idSubCategoria'];
        $res = mssql_query($sql);
        $num = mssql_num_rows($res);
        if ($num < 0) {
            $sql = "INSERT INTO prd_SubCategorias VALUES(" . $arr['idSubCategoria'] . ", " . $arr['idCategoria'] . ", 'SEM SUBCATEGORIA', GETDATE())";
            mssql_query($sql);
        }

        $sql = 'SELECT * FROM prd_TabelasNutricionais WHERE idProduto = ' . $arr['idProduto'];
        $res = mssql_query($sql);
        $nutri = mssql_fetch_assoc($res);
        $arr['nutricional'] = $nutri;
        if (mssql_num_rows($res) > 0) {
            $arr['flNutricional'] = 1;
        }
        $log = "SELECT TOP 1 stOperador FROM nat_Log WHERE stArea = 'PRODUTOS' AND stDescricao like '%" . $arr['idProduto'] . "%'";
        $userLog = mssql_fetch_assoc(mssql_query($log));
        $arr['userLog'] = utf8_encode($userLog['stOperador']);

        $saldo_qry = "SELECT nrQuantidade FROM est_Saldos WHERE est_Saldos.idProduto =" .$arr['idProduto']. "AND idEstoque = 1";
        $saldo = mssql_fetch_assoc(mssql_query($saldo_qry));
        $arr['saldo'] = $saldo['nrQuantidade'];

        $arr['dtAlteracao'] = date("d/m/Y H:i", strtotime($arr['dtAlteracao']));
        $arr['dtUltimaAlteracao'] = date("d/m/Y H:i", strtotime($arr['dtUltimaAlteracao']));
        $arr['dtInicioPromocao'] = date("d/m/Y H:i", strtotime($arr['dtInicioPromocao']));
        $arr['dtFimPromocao'] = date("d/m/Y H:i", strtotime($arr['dtFimPromocao']));
        $arr['hrInicioPromocaoHora'] = date("H:i", strtotime($arr['dtInicioPromocaoHora']));
        $arr['hrFimPromocaoHora'] = date("H:i", strtotime($arr['dtFimPromocaoHora']));
        $arr['stLocalizacao'] = utf8_encode($arr['stLocalizacao']);
        $arr['stProduto'] = utf8_encode($arr['stProduto']);
        $arr['stProdutoAbreviado'] = utf8_encode($arr['stProdutoAbreviado']);
        $arr['stOperador'] = utf8_encode($arr['stOperador']);
        $arr['stSetor'] = utf8_encode($arr['stSetor']);
        $arr['stCategoria'] = utf8_encode($arr['stCategoria']);
        $arr['stLocalizacao'] = utf8_encode($arr['stLocalizacao']);
        $arr['stDescricao'] = sanitizeString4($arr['stDescricao']);
        $arr['vrUnitarioPromocao'] = number_format($arr['vrUnitarioPromocao'], 2, ",", "");
        $arr['vrUnitarioPromocaoHora'] = number_format($arr['vrUnitarioPromocao'], 2, ",", "");
        $arr['saldo'] = number_format($arr['saldo'], 3, ".", "");

        $qryCodigos = "SELECT * FROM prd_Codigos WHERE idProduto = " . $arr['idProduto'];
        $resCodigos = mssql_query($qryCodigos);
        $arr['idCodigo'] = array();
        while ($arrCodigos = mssql_fetch_assoc($resCodigos)) {
            array_push($arr['idCodigo'], $arrCodigos['idCodigo']);
        }

        $sql = "SELECT TOP 1 idCodigo FROM prd_Codigos c INNER JOIN prd_Produtos p ON c.idProduto = p.idProduto WHERE p.flAtivo = 1 ORDER BY idCodigo ASC";
        $res = mssql_query($sql);
        $first = mssql_fetch_array($res);
        $arr['primeiro'] = $first[0];

        $sql = "SELECT TOP 1 idCodigo FROM prd_Codigos c INNER JOIN prd_Produtos p ON c.idProduto = p.idProduto WHERE p.flAtivo = 1 ORDER BY idCodigo DESC";
        $res = mssql_query($sql);
        $last = mssql_fetch_array($res);
        $arr['ultimo'] = $last[0];
        $sql = "SELECT TOP 1 idCodigo FROM prd_Codigos c INNER JOIN prd_Produtos p ON c.idProduto = p.idProduto WHERE idCodigo > '" . $id . "' AND p.flAtivo = 1 ORDER BY idCodigo ASC";
        $res = mssql_query($sql);
        $next = mssql_fetch_array($res);
        $arr['proximo'] = $next[0];

        $sql = "SELECT TOP 1 idCodigo FROM prd_Codigos c INNER JOIN prd_Produtos p ON c.idProduto = p.idProduto WHERE idCodigo < '" . $id . "' AND p.flAtivo = 1  ORDER BY idCodigo DESC";
        $res = mssql_query($sql);
        $previous = mssql_fetch_array($res);
        $arr['anterior'] = $previous[0];

    } else {
        $sql = "SELECT p.stProduto, p.stProdutoAbreviado, p.vrUnitario, m.stMedida, c.stCategoria, s.stSetor, a.stAliquota, l.stLocalizacao, p.dtAlteracao, n.* FROM prd_Produtos p
		LEFT JOIN prd_Medidas m ON p.idMedida = m.idMedida
		LEFT JOIN prd_Categorias c ON p.idCategoria = c.idCategoria
		LEFT JOIN prd_Setores s ON p.idSetor = s.idSetor
		LEFT JOIN prd_Aliquotas a ON p.idAliquota = a.idAliquota
		LEFT JOIN prd_Localizacoes l ON p.idLocalizacao = l.idLocalizacao
		LEFT JOIN prd_TabelasNutricionais n ON p.idProduto = n.idProduto
		WHERE p.idProduto = " . $id . " AND c.flAtivo = '1' AND s.flAtivo = '1' AND a.flAtivo = '1' AND l.flAtivo = '1'";

        $res = mssql_query($sql);
        $arr = mssql_fetch_assoc($res);
        $arr['dtAlteracao'] = date("d/m/Y H:i", strtotime($arr['dtAlteracao']));
        $arr['stLocalizacao'] = utf8_encode($arr['stLocalizacao']);
        $arr['stProduto'] = utf8_encode($arr['stProduto']);

        $sql = "SELECT TOP 1 idProduto FROM prd_Produtos WHERE flAtivo = 0 ORDER BY idProduto ASC";
        $res = mssql_query($sql);
        $first = mssql_fetch_array($res);
        $arr['primeiro'] = $first[0];

        $sql = "SELECT TOP 1 idProduto FROM prd_Produtos  WHERE flAtivo = 0 ORDER BY idProduto DESC";
        $res = mssql_query($sql);
        $last = mssql_fetch_array($res);
        $arr['ultimo'] = $last[0];
        $sql = "SELECT TOP 1 idProduto FROM prd_Produtos  WHERE idProduto > " . $id . " AND flAtivo = 0 ORDER BY idProduto ASC";
        $res = mssql_query($sql);
        $next = mssql_fetch_array($res);
        $arr['proximo'] = $next[0];

        $sql = "SELECT TOP 1 idProduto FROM prd_Produtos WHERE idProduto < " . $id . " AND flAtivo = 0  ORDER BY idProduto DESC";
        $res = mssql_query($sql);
        $previous = mssql_fetch_array($res);
        $arr['anterior'] = $previous[0];
    }
    // var_dump($arr);
    echo json_encode($arr);
}

function getFornecedoresByCodigoProduto($idCodigo)
{
    $sql = "SELECT f.idFornecedor, f.stNomeFornecedor FROM frn_Fornecedores f
	INNER JOIN frn_FichaFornecedor I ON f.idFornecedor = I.idFornecedor
	LEFT JOIN prd_Codigos c ON I.idProduto = c.idProduto
	WHERE c.idCodigo = '" . $idCodigo . "'
	ORDER BY f.stNomeFornecedor";
    $res = mssql_query($sql);

    while ($arr = mssql_fetch_assoc($res)) {
        $qry = "SELECT TOP(1) M.dtData, I.vrValor FROM est_Movimentacoes M
		INNER JOIN est_ItensMovimentacao I on I.idAbertura = M.idAbertura and I.idMovimentacao = M.idMovimentacao
		LEFT JOIN prd_Codigos c ON c.idProduto = I.idProduto
		where
		c.idCodigo = '" . $idCodigo . "'
		and M.idOrigem = " . $arr['idFornecedor'] . "
		and M.idAbertura = '0'
		and M.flEntrada = 'true'
		and M.flTipoEstoque = 'false'
		and M.flTipoOrigem = 'true'
		and M.flTipoDestino = 'true'
		and M.flAtivo = 'true'
		order by M.dtData";
        $resQry = mssql_query($qry);
        $arrQry = mssql_fetch_assoc($resQry);
        $arrQry['stNomeFornecedor'] = $arr['stNomeFornecedor'];
        if (!$arrQry['dtData']) {
            $arrQry['dtData'] = "Sem Informações";
        } else {

            $arrQry['dtData'] = date("d/m/Y H:i", strtotime($arrQry['dtData']));
        }
        if (!$arrQry['vrValor']) {
            $arrQry['vrValor'] = "Sem Informações";
        }
        $rows[] = $arrQry;
    }

    echo json_encode($rows);
}

function desativarProduto($idCodigo)
{
    beginTransaction();
    $trans = true;

    $sql = "SELECT p.idProduto FROM prd_Produtos p
	INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
	where idCodigo = '" . $idCodigo."'";

    $res = mssql_query($sql);
    $arr = mssql_fetch_array($res);


    $qry = 'DELETE FROM prd_codigos WHERE idProduto = ' . $arr[0];
    $res = mssql_query($qry) or $trans = false;

    $qry = 'UPDATE prd_Produtos SET flAtivo = 0	WHERE idProduto = ' . $arr[0];
    $res = mssql_query($qry) or $trans = false;

    if (!$trans) {
        rollback();
        echo retornaJson(false, 'Erro ao desativar produto');
    } else {
        commit();
        echo retornaJson(true, 'Produto desativado com sucesso');
    }
}

function reativarProduto($idProduto)
{
    $trans = true;
    beginTransaction();
    $qry = "SELECT MIN(CONVERT(bigint, idCodigo)) + 1 FROM prd_Codigos c
	WHERE not exists (SELECT * FROM prd_Codigos c2 WHERE CONVERT(bigint, c.idCodigo) + 1 = c2.idCodigo) AND (CONVERT(bigint, c.idCodigo)) > 0";

    $idCodigo = mssql_fetch_array(mssql_query($qry))[0];

    $qry = 'UPDATE prd_Produtos SET flAtivo = 1 WHERE idProduto = ' . $idProduto;
    $res = mssql_query($qry) or $trans = false;

    $qry = "INSERT INTO prd_Codigos (idCodigo, idProduto, dtALteracao) VALUES ('" . $idCodigo . "', " . $idProduto . ", GETDATE())";
    $res = mssql_query($qry) or $trans = false;

    if (!$trans) {
        rollback();
        echo retornaJson(false, 'Erro ao reativar produto');
    } else {
        commit();
        echo retornaJson(true, 'Produto reativado com sucesso');
    }
}

function getAliquota()
{
    $qry = "SELECT * FROM prd_Aliquotas WHERE flAtivo = '1' ORDER BY stAliquota ASC";
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getSubCategoriaByCategoria($idCategoria)
{
    if ($idCategoria == 0) {
        $qryId = "SELECT TOP 1 idCategoria FROM prd_Categorias ORDER BY stCategoria";
        $idCategoria = mssql_fetch_array(mssql_query($qryId))[0];
    }
    $qry = "SELECT * FROM prd_SubCategorias WHERE idCategoria = " . $idCategoria . " ORDER BY stSubCategoria";
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $arr['stSubCategoria'] = utf8_encode($arr['stSubCategoria']);
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function checkCodigoProduto($codigoProduto)
{
    $trans = true;
    for ($i = 0; $i < count($codigoProduto); $i++) {
        if (strlen($codigoProduto[$i]) > 0) {
            $qry = "SELECT * FROM prd_Codigos WHERE idCodigo = '" . $codigoProduto[$i] . "'";
            $num = mssql_num_rows(mssql_query($qry));
            if ($num > 0) {
                $trans = false;
            }
        }
    }
    if ($trans) {
        if (count($codigoProduto) > 1) {
            echo retornaJson(true, 'Códigos disponíveis.');
        } else {

            echo retornaJson(true, 'Código disponível.');
        }
    } else {
        if (count($codigoProduto) > 1) {
            echo retornaJson(false, 'Códigos já cadastrados.');
        } else {

            echo retornaJson(false, 'Código já cadastrado.');
        }
    }
}

function getMaxCodigo()
{
    $qry = "SELECT MIN(CONVERT(bigint, idCodigo)) + 1 FROM prd_Codigos c
	WHERE not exists (SELECT * FROM prd_Codigos c2 WHERE CONVERT(bigint, c.idCodigo) + 1 = c2.idCodigo) AND (CONVERT(bigint, c.idCodigo)) > 0";

    $codigoProduto = mssql_fetch_array(mssql_query($qry))[0];

    if (mssql_fetch_array(mssql_query($qry))[0] === NULL) {
        $codigoProduto = 1;
    }

    echo $codigoProduto;
}

function getEstoquesOrigem()
{
    $qry = "SELECT * FROM est_Estoques WHERE flOrigem = 'true'";
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function cadastrarProduto($request)
{
    $selectCategoria = $request['selectCategoria'];
    $selectMedidaVenda = $request['selectMedidaVenda'];
    $codigoProduto = $request['codigoProduto'];
    $descProduto = $request['descProduto'];
    $abrProduto = $request['abrProduto'];
    $selectSubCategoria = $request['selectSubCategoria'];
    $selectSetor = $request['selectSetor'];
    $selectLocal = $request['selectLocal'];
    $vrCusto = $request['vrCusto'];
    $vrPrecoVenda = $request['vrPrecoVenda'];
    $vrMargemLucro = $request['vrMargemLucro'];
    $vrTabela2 = $request['vrTabela2'];
    $flCustoCartao = $request['flCustoCartao'];
    $flDesconto = $request['flDesconto'];
    $flCobrarServico = $request['flCobrarServico'];
    $flCupomPre = $request['flCupomPre'];
    $selectAliquota = $request['selectAliquota'];
    $selectNCM = $request['selectNCM'];
    $stCest = $request['stCest'];
    $selectTipoProduto = $request['selectTipoProduto'];
    $selectMedidaCompra = $request['selectMedidaCompra'];
    $selectTipoFiscal = $request['selectTipoFiscal'];
    $flPromo = $request['flPromo'];
    $dtDePromo = $request['dtDePromo'];
    $hrDePromo = $request['hrDePromo'];
    $dtAtePromo = $request['dtAtePromo'];
    $hrAtePromo = $request['hrAtePromo'];
    $vrPrecoPromo = $request['vrPrecoPromo'];
    $flPromoHora = $request['flPromoHora'];
    $hrDePromoHora = $request['hrDePromoHora'];
    $hrAtePromoHora = $request['hrAtePromoHora'];
    $vrPrecoPromoHora = $request['vrPrecoPromoHora'];
    $nrValidade = $request['nrValidade'];
    $flEstoque = $request['flEstoque'];
    $estoques = $request['estoques'];
    $vrEstoques = $request['vrEstoques'];
    $flItemAdicional = $request['flItemAdicional'];
    $flNutricional = $request['flNutricional'];
    $nrQuantidade = $request['nrQuantidade'];
    $nrUnidadePorcao = $request['nrUnidadePorcao'];
    $nrParteInteiraMedidaCaseira = $request['nrParteInteiraMedidaCaseira'];
    $nrParteDecimalMedidaCaseira = $request['nrParteDecimalMedidaCaseira'];
    $nrMedidaCaseira = $request['nrMedidaCaseira'];
    $nrValorEnergetico = $request['nrValorEnergetico'];
    $nrCarboidratos = $request['nrCarboidratos'];
    $nrFibra = $request['nrFibra'];
    $nrGorSaturada = $request['nrGorSaturada'];
    $nrProteinas = $request['nrProteinas'];
    $nrSodio = $request['nrSodio'];
    $nrGorTotais = $request['nrGorTotais'];
    $nrGorTrans = $request['nrGorTrans'];
    $stAdicional = $request['stAdicional'];


    beginTransaction();
    $trans = true;
    //SAÍDAS DE ERRO
    if (preg_match('/[\'^£$%&*()}{@#~?><>,|=_+¬-]/', $codigoProduto)) {
        echo retornaJson(false, 'CodigoProduto');
        die;
    }
    $codigoProduto = explode(";", $codigoProduto);
    if (count($codigoProduto) > 0) {
        for ($i = 0; $i < count($codigoProduto); $i++) {
            if (strlen($codigoProduto[$i])) {
                $cdProduto = "SELECT * FROM prd_Codigos WHERE idCodigo = '" . $codigoProduto[$i] . "'";
                $resProduto = mssql_query($cdProduto);
                if (mssql_num_rows($resProduto)) {
                    echo retornaJson(false, 'CodigoProduto');
                    die;
                }
            }
        }
    } else {
        echo retornaJson(false, 'CodigoProduto');
        die;
    }
    if (strlen($descProduto) == 0) {
        echo retornaJson(false, 'DescProduto');
        die;
    } else {
        $descProduto = trim($descProduto);
    }
    if (strlen($abrProduto) == 0) {
        echo retornaJson(false, 'AbrProduto');
        die;
    } else {
        $abrProduto = trim($abrProduto);
    }
    if (strlen($vrCusto) == 0) {
        echo retornaJson(false, 'VrCusto');
        die;
    } else {
        $vrCusto = str_replace(".", "", $vrCusto);
        $vrCusto = str_replace(",", ".", $vrCusto);
    }
    if (strlen($vrPrecoVenda) == 0) {
        echo retornaJson(false, 'VrPrecoVenda');
        die;
    } else {
        $vrPrecoVenda = str_replace(".", "", $vrPrecoVenda);
        $vrPrecoVenda = str_replace(",", ".", $vrPrecoVenda);
    }
    if (strlen($vrMargemLucro) == 0) {
        echo retornaJson(false, 'vrMargemLucro');
        die;
    } else {
        $vrMargemLucro = str_replace(".", "", $vrMargemLucro);
        $vrMargemLucro = str_replace(",", ".", $vrMargemLucro);
    }
    if (!$selectNCM || strlen($selectNCM) <= 7 || is_null($selectNCM)) {
        echo retornaJson(false, 'NCM');
        die;
    }
    if (strlen($stAdicional) == 0) {
        $descLonga = '';
    } else {
        $descLonga = sanitizeString4($stAdicional);
    }
    if (strlen($abrProduto) == 0) {
        $abrProduto = '';
    }

    if (strlen($vrTabela2) == 0) {
        $vrTabela2 = '0';
    } else {
        $vrTabela2 = str_replace(".", "", $vrTabela2);
        $vrTabela2 = str_replace(",", ".", $vrTabela2);
    }
    if ($flCustoCartao == "0") {
        $flCustoTicket = 1;
        $flCustoSmart = 1;
        $flCustoCartao = 1;
    } else {
        $flCustoCartao = 0;
        $flCustoTicket = 0;
        $flCustoSmart = 0;
    }
    if ($flDesconto == 1) {
        $flDesconto = 0;
    } else {
        $flDesconto = 1;
    }
    if ($flCobrarServico == 1) {
        $flCobrarServico = 0;
    } else {
        $flCobrarServico = 1;
    }
    if ($flCupomPre == 1) {
        $flCupomPre = 0;
    } else {
        $flCupomPre = 1;
    }
    if ($flPromo) {
        $dtDePromo = explode("/", $dtDePromo);
        $dtAtePromo = explode("/", $dtAtePromo);
        if (count($dtDePromo) < 3 || strlen($dtDePromo[2]) < 4) {
            echo retornaJson(false, 'DataDePromo');
            die;
        }
        if (count($dtAtePromo) < 3 || strlen($dtAtePromo[2]) < 4) {
            echo retornaJson(false, 'DataAtePromo');
            die;
        }
        if (strlen($hrDePromo) < 5) {
            echo retornaJson(false, 'DataDePromo');
            die;
        }
        if (strlen($hrAtePromo) < 5) {
            echo retornaJson(false, 'DataAtePromo');
            die;
        }
        if (strlen($vrPrecoPromo) == 0) {
            echo retornaJson(false, 'VrPrecoPromo');
            die;
        } else {
            $vrPrecoPromo = str_replace(".", "", $vrPrecoPromo);
            $vrPrecoPromo = str_replace(",", ".", $vrPrecoPromo);

        }

        $dtInicioPromocao = date($dtDePromo[2] . "-" . $dtDePromo[1] . "-" . $dtDePromo[0] . " " . $hrDePromo . ":00");
        $dtFimPromocao = date($dtAtePromo[2] . "-" . $dtAtePromo[1] . "-" . $dtAtePromo[0] . " " . $hrAtePromo . ":00");
    }

    if ($flPromoHora) {
        if (strlen($hrDePromoHora) < 5) {
            echo retornaJson(false, 'DataDePromoHora');
            die;
        }
        if (strlen($hrAtePromoHora) < 5) {
            echo retornaJson(false, 'DataAtePromoHora');
            die;
        }
        if (strlen($vrPrecoPromoHora) == 0) {
            echo retornaJson(false, 'VrPrecoPromoHora');
            die;
        } else {
            $vrPrecoPromoHora = str_replace(".", "", $vrPrecoPromoHora);
            $vrPrecoPromoHora = str_replace(",", ".", $vrPrecoPromoHora);
        }

        $dtInicioPromocaoHora = "2017-01-01 " . $hrDePromoHora . ":000";
        $dtFimPromocaoHora = "2017-12-30 " . $hrAtePromoHora . ":000";
    }

    $stCest = str_replace(".", "", $stCest);

    $qry = 'SELECT MAX(idProduto) FROM prd_Produtos';
    $idProduto = mssql_fetch_array(mssql_query($qry))[0] + 1;

    $res = mssql_query("SELECT * FROM op_Operadores WHERE idOperador = " . $_COOKIE['idOperador']);
    $arr = mssql_fetch_array($res);
    $stApelido = $arr['stApelido'];

    $qryAl = mssql_query("SELECT * FROM prd_Aliquotas where idAliquota=" . $selectAliquota);
    $arr = mssql_fetch_assoc($qryAl);

    // TRATAMENTO DE CAMPOS DE MODULO OPCIONAIS
    $qry = 'SELECT produtos FROM nat_Modules';
    $arr = mssql_fetch_assoc(mssql_query($qry));
    $modulos = explode(';', base64_decode($arr['produtos']));
    if ($modulos[0] == 'false') {
        $categoria = "SELECT idCategoria from prd_Categorias WHERE stCategoria = 'SEM CATEGORIA'";
        $categoria = mssql_fetch_array(mssql_query($categoria));
        $selectCategoria = $categoria[0];
        $selectSubCategoria = 1;
    }
    if ($modulos[2] == 'false') {
        $local = "SELECT idLocalizacao from prd_Localizacoes WHERE stLocalizacao = 'SEM LOCAL'";
        $local = mssql_fetch_array(mssql_query($local));
        $selectLocal = $local[0];
    }
    if ($modulos[3] == 'false') {
        $setor = "SELECT idSetor from prd_Setores WHERE stSetor = 'SEM SETOR'";
        $setor = mssql_fetch_array(mssql_query($setor));
        $selectSetor = $setor[0];
    }


    $qry = "INSERT INTO prd_Produtos (idProduto, stOperador, idMedida, idCategoria, stProduto, stProdutoAbreviado, 
            idSubCategoria, idSetor, idLocalizacao, stDescricao, vrCusto, vrUnitario, vrMargemLucro, vrUnitario2, 
            flVendaCartao, flVendaTicket, flVendaSmart, flDesconto, flComissao, flCupomPreVenda,
            idAliquota, nrNCM, stCest, idTipoProduto, idMedidaCompra, nrTipoProduto, nrFatorConversao, flPromocao,
            flPromocaoHora, nrValidade, flControlarEstoque, flRequererItemAdicional";

    if ($flPromo) {
        $qry .= ", dtInicioPromocao, dtFimPromocao, vrUnitarioPromocao";
    }

    if ($flPromoHora) {
        $qry .= ", dtInicioPromocaoHora, dtFimPromocaoHora, vrUnitarioPromocaoHora";
    }
    $qry .= ")";

    $qry .= "VALUES(" . $idProduto . ",'" . $stApelido . "'," . $selectMedidaVenda . "," . $selectCategoria . ",'"
        . $descProduto . "','" . $abrProduto . "'," . $selectSubCategoria . "," . $selectSetor . "," . $selectLocal
        . ",'" . $descLonga . "', '" . $vrCusto . "','" . $vrPrecoVenda . "', '" . $vrMargemLucro . "', '" . $vrTabela2
        . "', " . $flCustoCartao . ", " . $flCustoTicket . ", " . $flCustoSmart . ", " . $flDesconto . ", " . $flCobrarServico
        . ", " . $flCupomPre . ", '" . $selectAliquota . "', '" . $selectNCM . "', '" . $stCest . "' , '" . $selectTipoProduto . "', '"
        . $selectMedidaCompra . "', '" . $selectTipoFiscal . "', '1', '" . $flPromo ."', '"
        . $flPromoHora . "', '" . $nrValidade . "' ,'" . $flEstoque . "' , '" . $flItemAdicional . "'";

    if ($flPromo) {
        $qry .= ", '" . $dtInicioPromocao . "', '" . $dtFimPromocao . "', '" . $vrPrecoPromo . "'";
    }

    if ($flPromoHora) {
        $qry .= ", '" . $dtInicioPromocaoHora . "', '" . $dtFimPromocaoHora . "', '" . $vrPrecoPromoHora . "'";
    }
    $qry .= ")";

    mssql_query($qry) or $trans = false;
    if ($trans) {
        if ($flNutricional) {
            $nrQuantidade = str_replace(",", ".", $nrQuantidade);
            $nrUnidadePorcao = str_replace(",", ".", $nrUnidadePorcao);
            $nrParteInteiraMedidaCaseira = str_replace(",", ".", $nrParteInteiraMedidaCaseira);
            $nrParteDecimalMedidaCaseira = str_replace(",", ".", $nrParteDecimalMedidaCaseira);
            $nrMedidaCaseira = str_replace(",", ".", $nrMedidaCaseira);
            $nrValorEnergetico = str_replace(",", ".", $nrValorEnergetico);
            $nrCarboidratos = str_replace(",", ".", $nrCarboidratos);
            $nrProteinas = str_replace(",", ".", $nrProteinas);
            $nrGorTotais = str_replace(",", ".", $nrGorTotais);
            $nrGorSaturada = str_replace(",", ".", $nrGorSaturada);
            $nrGorTrans = str_replace(",", ".", $nrGorTrans);
            $nrFibra = str_replace(",", ".", $nrFibra);
             $nrSodio = str_replace(",", ".", $nrSodio);
//            $nrSodio = $nrSodio + ".00";
            $qry = 'SELECT MAX(idTabelaNutricional) + 1 FROM prd_TabelasNutricionais';
            $idTabela = mssql_fetch_array(mssql_query($qry))[0];
            $qry = "INSERT INTO prd_TabelasNutricionais (idTabelaNutricional, idProduto, nrQuantidade, nrUnidadePorcao, nrParteInteiraMedidaCaseira, nrParteDecimalMedidaCaseira, nrMedidaCaseira, nrValorEnergetico, nrCarboidratos, nrProteinas, nrGordurasTotais, nrGordurasSaturadas, nrGordurasTrans, nrFibraAlimentar, nrSodio) VALUES(" . $idTabela . ", " . $idProduto . ", " . $nrQuantidade . ", " . $nrUnidadePorcao . ", " . $nrParteInteiraMedidaCaseira . ", " . $nrParteDecimalMedidaCaseira . ", " . $nrMedidaCaseira . ", " . $nrValorEnergetico . ", " . $nrCarboidratos . ", " . $nrProteinas . ", " . $nrGorTotais . ", " . $nrGorSaturada . ", " . $nrGorTrans . ", " . $nrFibra . ", " . $nrSodio . ")";
            mssql_query($qry);
        }
        for ($i = 0; $i < count($codigoProduto); $i++) {
            if (strlen($codigoProduto[$i]) > 0) {
                $codigoProduto[$i] = trim($codigoProduto[$i]);
                $qry = "INSERT INTO prd_Codigos(idCodigo, idProduto, dtAlteracao) VALUES('" . $codigoProduto[$i] . "', " . $idProduto . ", GETDATE())";
                mssql_query($qry) or $trans = false;
            }
        }
        if ($trans && $flEstoque) {
            $estoques = explode('/', $estoques);
            $vrEstoques = explode('/', $vrEstoques);
            for ($i = 0; $i < (count($estoques) - 1); $i++) {
                $qryIdSaldo = 'SELECT MAX(idSaldo) FROM est_Saldos';
                $idSaldo = mssql_fetch_array(mssql_query($qryIdSaldo))[0] + 1;
                $qryInsertSaldo = "INSERT INTO est_Saldos (idSaldo, idEstoque, idProduto, nrQuantidade, nrReservas, dtModificacao, dtConferencia, nrMinimo, dtAlteracao)
				VALUES(" . $idSaldo . ", " . $estoques[$i] . ", " . $idProduto . ", " . $vrEstoques[$i] . ", 0, GETDATE(), GETDATE(), 0, GETDATE())";
                mssql_query($qryInsertSaldo) or $trans = false;
            }
            if ($trans) {
                commit();
                echo retornaJson(true, 'Cadastrado com sucesso');
                die;
            } else {
                rollback();
                echo retornaJson(false, 'Erro ao cadastrar estoque inicial');
                die;
            }
        }
        if ($trans) {
            commit();
            echo retornaJson(true, 'Cadastrado com sucesso');
            die;
        } else {
            rollback();
            echo retornaJson(false, 'Erro ao cadastrar código do produto');
            die;
        }
    } else {
        rollback();
        echo retornaJson(false, 'Erro ao cadastrar produto');
        die;
    }
}

function getSaldoEditProduto($idProduto)
{
    $qry = 'SELECT s.idEstoque, s.idSaldo, s.nrQuantidade FROM est_Saldos s INNER JOIN est_Estoques e ON s.idEstoque = e.idEstoque WHERE e.flOrigem = 1 AND idProduto =' . $idProduto;
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function editarProduto($request)
{

    $idProdutoModal = $request['idProdutoModal'];
    $selectCategoria = $request['selectCategoria'];
    $selectMedidaVenda = $request['selectMedidaVenda'];
    $codigoProduto = $request['codigoProduto'];
    $descProduto = $request['descProduto'];
    $abrProduto = $request['abrProduto'];
    $selectSubCategoria = $request['selectSubCategoria'];
    $selectSetor = $request['selectSetor'];
    $selectLocal = $request['selectLocal'];
    $vrCusto = $request['vrCusto'];
    $vrPrecoVenda = $request['vrPrecoVenda'];
    $vrMargemLucro = $request['vrMargemLucro'];
    $vrTabela2 = $request['vrTabela2'];
    $flCustoCartao = $request['flCustoCartao'];
    $flDesconto = $request['flDesconto'];
    $flCobrarServico = $request['flCobrarServico'];
    $flCupomPre = $request['flCupomPre'];
    $selectAliquota = $request['selectAliquota'];
    $selectNCM = $request['selectNCM'];
    $stCest = $request['stCest'];
    $selectTipoProduto = $request['selectTipoProduto'];
    $selectMedidaCompra = $request['selectMedidaCompra'];
    $selectTipoFiscal = $request['selectTipoFiscal'];
    $flPromo = $request['flPromo'];
    $dtDePromo = $request['dtDePromo'];
    $hrDePromo = $request['hrDePromo'];
    $dtAtePromo = $request['dtAtePromo'];
    $hrAtePromo = $request['hrAtePromo'];
    $vrPrecoPromo = $request['vrPrecoPromo'];
    $flPromoHora = $request['flPromoHora'];
    $hrDePromoHora = $request['hrDePromoHora'];
    $hrAtePromoHora = $request['hrAtePromoHora'];
    $vrPrecoPromoHora = $request['vrPrecoPromoHora'];
    $nrValidade = $request['nrValidade'];
    $flEstoque = $request['flEstoque'];
    $estoques = $request['estoques'];
    $vrEstoques = $request['vrEstoques'];
    $flItemAdicional = $request['flItemAdicional'];
    $flNutricional = $request['flNutricional'];
    $nrQuantidade = $request['nrQuantidade'];
    $nrUnidadePorcao = $request['nrUnidadePorcao'];
    $nrParteInteiraMedidaCaseira = $request['nrParteInteiraMedidaCaseira'];
    $nrParteDecimalMedidaCaseira = $request['nrParteDecimalMedidaCaseira'];
    $nrMedidaCaseira = $request['nrMedidaCaseira'];
    $nrValorEnergetico = $request['nrValorEnergetico'];
    $nrCarboidratos = $request['nrCarboidratos'];
    $nrFibra = $request['nrFibra'];
    $nrGorSaturada = $request['nrGorSaturada'];
    $nrProteinas = $request['nrProteinas'];
    $nrSodio = $request['nrSodio'];
    $nrGorTotais = $request['nrGorTotais'];
    $nrGorTrans = $request['nrGorTrans'];
    $stAdicional = $request['stAdicional'];
    $idSaldos = $request['idSaldos'];


    beginTransaction();
    $trans = true;
    //SAÍDAS DE ERRO
    $codigoProduto = explode(";", $codigoProduto);
    $nrCodigos = count($codigoProduto);
    if ($nrCodigos > 0) {
        $qryCodProduto = "DELETE FROM prd_Codigos WHERE idProduto = " . $idProdutoModal;
        mssql_query($qryCodProduto) or $trans = false;
        for ($i = 0; $i < $nrCodigos; $i++) {
            if (strlen($codigoProduto[$i]) > 0) {
                $codigoProduto[$i] = trim($codigoProduto[$i]);
                $qry = "INSERT INTO prd_Codigos(idCodigo, idProduto, dtAlteracao) VALUES('" . $codigoProduto[$i] . "', " . $idProdutoModal . ", GETDATE())";
                mssql_query($qry) or $trans = false;
            } else {
                if ($nrCodigos == 1) {
                    echo retornaJson(false, 'CodigoProduto');
                    die;
                }
            }
        }
    } else {
        echo retornaJson(false, 'CodigoProduto');
        die;
    }
    if (strlen($descProduto) == 0) {
        echo retornaJson(false, 'DescProduto');
        die;
    } else {
        $descProduto = trim($descProduto);
    }
    if (strlen($abrProduto) == 0) {
        echo retornaJson(false, 'AbrProduto');
        die;
    } else {
        $abrProduto = trim($abrProduto);
    }
    if (strlen($vrCusto) == 0) {
        echo retornaJson(false, 'VrCusto');
        die;
    } else {
        $vrCusto = str_replace(".", "", $vrCusto);
        $vrCusto = str_replace(",", ".", $vrCusto);

    }
    if (strlen($vrPrecoVenda) == 0) {
        echo retornaJson(false, 'VrPrecoVenda');
        die;
    } else {
        $vrPrecoVenda = str_replace(".", "", $vrPrecoVenda);
        $vrPrecoVenda = str_replace(",", ".", $vrPrecoVenda);

    }
    if (strlen($vrMargemLucro) == 0) {
        echo retornaJson(false, 'vrMargemLucro');
        die;
    } else {
        $vrMargemLucro = str_replace(",", ".", $vrMargemLucro);

    }
    if (!$selectNCM || strlen($selectNCM) <= 7 || is_null($selectNCM)) {
        echo retornaJson(false, 'NCM');
        die;
    }

    //TRATAMENTO DE DADOS NÃO OBRIGATÓRIOS
    if (strlen($stAdicional) == 0) {
        $descLonga = '';
    } else {
        $descLonga = $stAdicional;
    }
    if (strlen($abrProduto) == 0) {
        $abrProduto = '';
    }
    if (!$selectSubCategoria) {
        $selectSubCategoria = 1;
    }
    if (strlen($vrTabela2) == 0) {
        $vrTabela2 = '0';
    } else {
        $vrTabela2 = str_replace(".", "", $vrTabela2);
        $vrTabela2 = str_replace(",", ".", $vrTabela2);

    }
    if ($flCustoCartao == "0") {
        $flCustoTicket = 1;
        $flCustoSmart = 1;
        $flCustoCartao = 1;
    } else {
        $flCustoCartao = 0;
        $flCustoTicket = 0;
        $flCustoSmart = 0;
    }
    if ($flDesconto == 1) {
        $flDesconto = 0;
    } else {
        $flDesconto = 1;
    }
    if ($flCobrarServico == 1) {
        $flCobrarServico = 0;
    } else {
        $flCobrarServico = 1;
    }
    if ($flCupomPre == 1) {
        $flCupomPre = 0;
    } else {
        $flCupomPre = 1;
    }
    if ($flPromo) {
        $dtDePromo = explode("/", $dtDePromo);
        $dtAtePromo = explode("/", $dtAtePromo);
        if (count($dtDePromo) < 3 || strlen($dtDePromo[2]) < 4) {
            echo retornaJson(false, 'DataDePromo');
            die;
        }
        if (count($dtAtePromo) < 3 || strlen($dtAtePromo[2]) < 4) {
            echo retornaJson(false, 'DataAtePromo');
            die;
        }
        if (strlen($hrDePromo) < 5) {
            echo retornaJson(false, 'DataDePromo');
            die;
        }
        if (strlen($hrAtePromo) < 5) {
            echo retornaJson(false, 'DataAtePromo');
            die;
        }
        if (strlen($vrPrecoPromo) == 0) {
            echo retornaJson(false, 'VrPrecoPromo');
            die;
        } else {
            $vrPrecoPromo = str_replace(".", "", $vrPrecoPromo);
            $vrPrecoPromo = str_replace(",", ".", $vrPrecoPromo);
        }

        $dtInicioPromocao = date($dtDePromo[2] . "-" . $dtDePromo[1] . "-" . $dtDePromo[0] . " " . $hrDePromo . ":00");
        $dtFimPromocao = date($dtAtePromo[2] . "-" . $dtAtePromo[1] . "-" . $dtAtePromo[0] . " " . $hrAtePromo . ":00");
    }

    if ($flPromoHora) {
        if (strlen($hrDePromoHora) < 5) {
            echo retornaJson(false, 'DataDePromoHora');
            die;
        }
        if (strlen($hrAtePromoHora) < 5) {
            echo retornaJson(false, 'DataAtePromoHora');
            die;
        }
        if (strlen($vrPrecoPromoHora) == 0) {
            echo retornaJson(false, 'VrPrecoPromoHora');
            die;
        } else {
            $vrPrecoPromoHora = str_replace(".", "", $vrPrecoPromoHora);
            $vrPrecoPromoHora = str_replace(",", ".", $vrPrecoPromoHora);
        }

        $dtInicioPromocaoHora = "2017-01-01 " . $hrDePromoHora . ":00:000";
        $dtFimPromocaoHora = "2017-12-30 " . $hrAtePromoHora . ":00:000";
    }

    $stCest = str_replace(".", "", $stCest);

    $qryAl = mssql_query("SELECT * FROM prd_Aliquotas where idAliquota=" . $selectAliquota);
    $arr = mssql_fetch_assoc($qryAl);

    $qry = "UPDATE prd_Produtos SET idMedida = " . $selectMedidaVenda . ", idCategoria = " . $selectCategoria
        . ", stProduto= '" . $descProduto . "', stProdutoAbreviado = '" . $abrProduto . "', idSubCategoria = " . $selectSubCategoria
        . ", idSetor = " . $selectSetor . ", idLocalizacao = " . $selectLocal . ", stDescricao = '" . $descLonga
        . "', vrCusto= '" . $vrCusto . "', vrUnitario = '" . $vrPrecoVenda . "', vrMargemLucro = '" . $vrMargemLucro
        . "', vrUnitario2 = '" . $vrTabela2 . "', flVendaCartao = " . $flCustoCartao . ", flVendaTicket = " . $flCustoTicket
        . ", flVendaSmart = " . $flCustoSmart . ", flDesconto = " . $flDesconto . ", flComissao = " . $flCobrarServico
        . ", flCupomPreVenda = " . $flCupomPre . ", idAliquota = '" . $selectAliquota . "', nrNCM = '" . $selectNCM
        . "', stCest = '" . $stCest . "', idTipoProduto = '" . $selectTipoProduto . "', idMedidaCompra = '" . $selectMedidaCompra
        . "', nrTipoProduto = '" . $selectTipoFiscal . "', flPromocao = " . $flPromo . ", flPromocaoHora =  " . $flPromoHora
        . ", nrValidade = '" . $nrValidade . "', flControlarEstoque = " . $flEstoque . ", flRequererItemAdicional = "
        . $flItemAdicional . ", dtUltimaAlteracao = GETDATE(), dtAlteracao = GETDATE()";

    if ($flPromo) {
        $qry .= ", dtInicioPromocao = '" . $dtInicioPromocao . "', dtFimPromocao = '" . $dtFimPromocao . "', vrUnitarioPromocao = '" . $vrPrecoPromo . "'";
    }

    if ($flPromoHora) {
        $qry .= ", dtInicioPromocaoHora = '" . $dtInicioPromocaoHora . "', dtFimPromocaoHora = '" . $dtFimPromocaoHora . "', vrUnitarioPromocaoHora ='" . $vrPrecoPromoHora . "'";
    }
    $qry .= " WHERE idProduto = " . $idProdutoModal;

    mssql_query($qry) or $trans = false;

    if ($trans) {
        if ($flNutricional) {
            $nrQuantidade = str_replace(",", ".", $nrQuantidade);
            $nrParteInteiraMedidaCaseira = str_replace(",", ".", $nrParteInteiraMedidaCaseira);
            $nrCarboidratos = str_replace(",", ".", $nrCarboidratos);
            $nrProteinas = str_replace(",", ".", $nrProteinas);
            $nrGorTotais = str_replace(",", ".", $nrGorTotais);
            $nrGorSaturada = str_replace(",", ".", $nrGorSaturada);
            $nrGorTrans = str_replace(",", ".", $nrGorTrans);
            $nrFibra = str_replace(",", ".", $nrFibra);
            $nrSodio = str_replace(",", ".", $nrSodio);
            $qry = "DELETE FROM prd_TabelasNutricionais WHERE idProduto = " . $idProdutoModal;
            mssql_query($qry);
            $qry = 'SELECT MAX(idTabelaNutricional) + 1 FROM prd_TabelasNutricionais';
            $idTabela = mssql_fetch_array(mssql_query($qry))[0];
            if (!$idTabela) {
                $idTabela = 1;
            }
            $qry = "INSERT INTO prd_TabelasNutricionais (idTabelaNutricional, idProduto, nrQuantidade, nrUnidadePorcao, nrParteInteiraMedidaCaseira, nrParteDecimalMedidaCaseira, nrMedidaCaseira, nrValorEnergetico, nrCarboidratos, nrProteinas, nrGordurasTotais, nrGordurasSaturadas, nrGordurasTrans, nrFibraAlimentar, nrSodio) VALUES(" . $idTabela . ", " . $idProdutoModal . ", " . $nrQuantidade . ", " . $nrUnidadePorcao . ", " . $nrParteInteiraMedidaCaseira . ", " . $nrParteDecimalMedidaCaseira . ", " . $nrMedidaCaseira . ", " . $nrValorEnergetico . ", " . $nrCarboidratos . ", " . $nrProteinas . ", " . $nrGorTotais . ", " . $nrGorSaturada . ", " . $nrGorTrans . ", " . $nrFibra . ", " . $nrSodio . ")";
            mssql_query($qry);
        } else {
            $qry = "DELETE FROM prd_TabelasNutricionais WHERE idProduto = " . $idProdutoModal;
            mssql_query($qry);
        }
        if ($flEstoque) {
            $estoques = explode('/', $estoques);
            $vrEstoques = explode('/', $vrEstoques);
            $idSaldos = explode('/', $idSaldos);
            for ($i = 0; $i < (count($estoques) - 1); $i++) {
                if ($idSaldos[$i]) {
                    $qryUpdateSaldos = "UPDATE est_Saldos SET nrQuantidade = '" . $vrEstoques[$i] . "', dtModificacao = GETDATE() WHERE idSaldo = " . $idSaldos[$i];
                    mssql_query($qryUpdateSaldos) or $trans = false;
                } else {
                    $qryIdSaldo = 'SELECT MAX(idSaldo) FROM est_Saldos';
                    $idSaldo = mssql_fetch_array(mssql_query($qryIdSaldo))[0] + 1;
                    $qryInsertSaldo = "INSERT INTO est_Saldos (idSaldo, idEstoque, idProduto, nrQuantidade, nrReservas, dtModificacao, dtConferencia,
					nrMinimo, dtAlteracao)
					VALUES(" . $idSaldo . ", " . $estoques[$i] . ", " . $idProdutoModal . ", " . $vrEstoques[$i] . ", 0, GETDATE(), GETDATE(), 0, GETDATE())";
                    mssql_query($qryInsertSaldo) or $trans = false;
                }
            }
            if ($trans) {
                commit();
                insertLog("PRODUTOS", "PRODUTO [$idProdutoModal - $descProduto] EDITADO.");
                echo retornaJson(true, 'Produto editado com sucesso');
                die;
            } else {
                rollback();
                echo retornaJson(false, 'Erro ao editar a quantidade do estoque do produto.');
                die;
            }
        }
        commit();
        insertLog("PRODUTOS", "PRODUTO [$idProdutoModal - $descProduto] EDITADO.");
        echo retornaJson(true, 'Produto editado com sucesso');
        die;
    } else {
        rollback();
        echo retornaJson(false, 'Erro ao editar o produto');
        die;
    }
}

function insertItemAdicional($idProdutoPrincipal, $idProduto, $qtd, $custo)
{
    $trans = true;
    $qryIdItem = 'SELECT MAX(idItem) FROM prd_FichaTecnica WHERE idProdutoPrincipal = ' . $idProdutoPrincipal;
    $idItem = mssql_fetch_array(mssql_query($qryIdItem))[0] + 1;

    $qryInsertItem = "INSERT INTO prd_FichaTecnica(idProdutoPrincipal, idItem, idProduto, nrQuantidade, vrCustoTotal, dtAlteracao)
	VALUES(" . $idProdutoPrincipal . ", " . $idItem . ", " . $idProduto . ", '" . $qtd . "', '" . $custo . "', GETDATE())";
    // var_dump($qryInsertItem);
    mssql_query($qryInsertItem) or $trans = false;

    if ($trans) {
        echo retornaJson(true, 'Item adicionado com sucesso');
    } else {
        echo retornaJson(false, 'Erro ao adicionar item');
    }
}

function removeItemAdicional($idProdutoPrincipal, $idProduto)
{
    $trans = true;
    $qry = "DELETE FROM prd_FichaTecnica WHERE idProdutoPrincipal =" . $idProdutoPrincipal . " AND idProduto = " . $idProduto;
    mssql_query($qry) or $trans = false;

    if ($trans) {
        echo retornaJson(true, 'Item adicional removido com sucesso.');
    } else {
        echo retornaJson(false, 'Erro ao remover item adicional.');
    }
}

function getItemAdicionalProduto($idProduto)
{
    $qry = "SELECT f.*, p.stProduto, m.stMedida FROM prd_FichaTecnica f
	INNER JOIN prd_Produtos p ON f.idProduto = p.idProduto
	INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
	WHERE idProdutoPrincipal = " . $idProduto;
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function popularNCM($texto)
{
    if (strlen($texto) > 0) {
        if (ctype_digit($texto)) {
            $qry = "SELECT TOP 15 * FROM ncm WHERE ncm LIKE '" . $texto . "%'";
        } else {
            $qry = "SELECT TOP 15 * FROM ncm WHERE stDesc LIKE '%" . $texto . "%'";
        }
        $res = mssql_query($qry);
        while ($arr = mssql_fetch_assoc($res)) {
            $arr['stDesc'] = utf8_encode($arr['stDesc']);
            $rows[] = $arr;
        }
        echo json_encode($rows);
    }
}

function getConfig()
{
    $qry = "SELECT flIdProduto, idConfig, flDtAlteracao, flCodigo, flDesc, flDescAbr, flCategoria, flSubCategoria, flMedidaCompra, flMedidaVenda, flSetor, flVrCompra, flVrVenda, flAliquota, flNCM FROM prd_Config";
    $res = mssql_query($qry);
    $arr = mssql_fetch_assoc($res);
    echo json_encode($arr);
}

function saveConfig($flIdProduto, $flDtAlteracao, $flCodigo, $flDesc, $flDescAbr, $flCategoria, $flSubCategoria, $flMedidaVenda, $flMedidaCompra, $flSetor, $flVrCompra, $flVrVenda, $flAliquota, $flNCM)
{
    $qry = 'DELETE FROM prd_Config';
    mssql_query($qry);
    $qry = "INSERT INTO prd_Config (idConfig, flIdProduto, flDtAlteracao, flCodigo, flDesc, flDescAbr, flCategoria, flSubCategoria, flMedidaCompra, flMedidaVenda, flSetor, flVrCompra, flVrVenda, flAliquota, flNCM) VALUES(1,". $flIdProduto."," . $flDtAlteracao . "," . $flCodigo . "," . $flDesc . "," . $flDescAbr . "," . $flCategoria . "," . $flSubCategoria . "," . $flMedidaCompra . "," . $flMedidaVenda . "," . $flSetor . "," . $flVrCompra . "," . $flVrVenda . "," . $flAliquota . ", " . $flNCM . ")";
    mssql_query($qry);
    echo retornaJson(true, 'Configurações Salvas.');
}

function getProductByProductId($status, $id)
{
    $qry = "SELECT p.idProduto, p.stProduto, m.flFracionado, p.vrCusto, (m.stMedida) as stMedidaVenda FROM prd_Produtos p
	LEFT JOIN prd_Medidas m ON p.idMedida = m.idMedida
	where idProduto = " . $id;
    $arr = mssql_fetch_assoc(mssql_query($qry));
    $arr['stProduto'] = utf8_encode($arr['stProduto']);
    $arr['stMedidaVenda'] = utf8_encode($arr['stMedidaVenda']);
    echo json_encode($arr);
}

function getConfigModulos()
{
    $qry = 'SELECT produtos FROM nat_Modules';
    $arr = mssql_fetch_assoc(mssql_query($qry));
    $modulos = explode(';', base64_decode($arr['produtos']));
    echo json_encode($modulos);
}

function obterCest($nrNcm)
{
    $NCM = $nrNcm;

    if (!$NCM) {
        echo json_encode("");
    } else {
        $qry = "SELECT nrCEST FROM cad_Cest WHERE nrNCM = " . $NCM;
        $res = mssql_fetch_assoc(mssql_query($qry));

        echo json_encode($res);
    }
}

?>
