<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
db_conn();

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'getOperadores':
		getOperadores();
		break;
		case 'gerarRelatorio':
		gerarRelatorio($_POST['de'], $_POST['ate'], $_POST['ids']);
		break;
	}
}


function getOperadores()
{
	$qry = "SELECT idOperador, stApelido, stCargo FROM op_Operadores WHERE flAtivo = '1' AND nrPontos > '0' ORDER BY stApelido";
	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['stApelido'] = utf8_encode($arr['stApelido']);
		$arr['stCargo'] = utf8_encode($arr['stCargo']);
		$result[] = $arr;
	}
	echo json_encode($result);
}

function gerarRelatorio($de, $ate, $ids)
{
	$de = explode('/', $de);
	$de = $de[2].'-'.$de[1].'-'.$de[0].' 00:00:00';
	$ate = explode('/', $ate);
	$ate = $ate[2].'-'.$ate[1].'-'.$ate[0].' 23:59:59';

	$qry = "SELECT stApelido FROM op_Operadores WHERE idOperador = ".$_COOKIE['idOperador'];
	$arr = mssql_fetch_array(mssql_query($qry));
	$result['stOperador'] = utf8_encode($arr[0]);
	$result['idOperador'] = $_COOKIE['idOperador'];

	$qry = "SELECT SUM(vrRepique) FROM cx_Repique WHERE flAtivo = 'true' AND dtData BETWEEN '".$de."' AND '".$ate."'";
	$arr = mssql_fetch_array(mssql_query($qry));
	$result['repique'] = $arr[0];

	$qry = "SELECT SUM(nrPontos) AS nrPontos FROM op_Operadores WHERE idOperador IN (".$ids.")";
	$arr = mssql_fetch_array(mssql_query($qry));
	$result['totalPontos'] = $arr[0];

	$qry = "SELECT SUM(I.vrTotal) AS vrTotal FROM (
	SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas
	UNION
	SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas_Temp
	) V INNER JOIN (
	SELECT idAbertura,idVenda,stAtendente,flAtivo,vrTotal FROM cx_Itens
	UNION
	SELECT idAbertura,idVenda,stAtendente,flAtivo,vrTotal FROM cx_Itens_Temp
	) I ON V.idAbertura = I.idAbertura AND V.idVenda = I.idVenda
	INNER JOIN op_Operadores O ON I.stAtendente = O.stApelido
	WHERE V.flAtivo = 1 AND I.flAtivo = 1 AND V.vrAcrescimo > 0 AND V.dtData BETWEEN '".$de."' AND '".$ate."' AND O.idOperador IN (".$ids.")";
	$arr = mssql_fetch_array(mssql_query($qry));
	$result['vrTotal'] = $arr[0];

	$qry = "SELECT * FROM vw_rel_comissao_pontos WHERE nrPontos > 0 AND idOperador IN(".$ids.") AND dtData BETWEEN '".$de."' AND '".$ate."'";
	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
        $taxa = $arr['vrTaxaServico'] > 1 ? $arr['vrTaxaServico']/100 :$arr['vrTaxaServico'];
		$arr['vrSubTotal'] = (($result['vrTotal'] * $taxa) * (((100*$arr['nrPontos'])/$result['totalPontos'])) / 100) + ($result['repique']*((((100*$arr['nrPontos'])/$result['totalPontos'])) / 100));
		$arr['porcentagem'] = (100*$arr['nrPontos'])/$result['totalPontos'];

		$arr['stApelido'] = utf8_encode($arr['stApelido']);
		$arr['porcentagem'] = number_format($arr['porcentagem'], 2, ',', '.');
		$arr['vrComissao'] = number_format($arr['vrComissao'], 2, ',', '.');
		$arr['vrSubTotal'] = number_format($arr['vrSubTotal'], 2, ',', '.');
		$arr['vrTaxaServico'] = number_format($taxa, 2, ',', '.');
		$arr['vrTotal'] = number_format($arr['vrTotal'], 2, ',', '.');
		$result['vendas'][] = $arr;
	}

	$result['repique'] = number_format($result['repique'], 2, ',', '.');
	$result['vrTotal'] = number_format($result['vrTotal'], 2, ',', '.');
	echo json_encode($result);
}
?>
