<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
db_conn();

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'relatorioSintetico':
		relatorioSintetico($_POST['month'], $_POST['year']);
		break;
		case 'getDadosOperador':
		getDadosOperador();
		break;
		case 'getEquipamentos':
		getEquipamentos();
		break;
		case 'relatorioDiario':
		relatorioDiario($_POST['month'], $_POST['year'], $_POST['equipamento']);
		break;
	}
}


function relatorioSintetico($month, $year)
{
	$lastDay = cal_days_in_month(CAL_GREGORIAN, $month, $year);
	if ($month < 10) {
		$month = '0' . $month;
	}
	$firstDay = $year . '-' . $month . '-01 00:00:00';
	$lastDay = $year . '-' . $month . '-'. $lastDay .' 23:59:59';
	$qryEquipamentos = "SELECT id, serial FROM sat_equipamentos";
	$res = mssql_query($qryEquipamentos);
	while ($arr = mssql_fetch_assoc($res)) {
		//Pegando os valores totais
		$qryTotais = "SELECT sum(vrIcms) as vrIcms, sum(vrPis) as vrPis, sum(vrCofins) as vrCofins, 
		sum(vrCofinsSt) as vrCofinsSt, sum(vrPisSt) as vrPisSt, sum(vrOutros) as vrOutros FROM sat_imposto i
		INNER JOIN sat_vendas v ON v.Imposto_Id = i.id
		INNER JOIN sat_equipamentos e ON v.EquipamentoId = e.id
		where e.id = ".$arr['id']." AND v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'";
		$arr['valoresTotais'] = mssql_fetch_assoc(mssql_query($qryTotais));
		$arr['valoresTotais']['vrCofins'] = number_format($arr['valoresTotais']['vrCofins'], 2, ',', '.');
		$arr['valoresTotais']['vrCofinsSt'] = number_format($arr['valoresTotais']['vrCofinsSt'], 2, ',', '.');
		$arr['valoresTotais']['vrIcms'] = number_format($arr['valoresTotais']['vrIcms'], 2, ',', '.');
		$arr['valoresTotais']['vrOutros'] = number_format($arr['valoresTotais']['vrOutros'], 2, ',', '.');
		$arr['valoresTotais']['vrPis'] = number_format($arr['valoresTotais']['vrPis'], 2, ',', '.');
		$arr['valoresTotais']['vrPisSt'] = number_format($arr['valoresTotais']['vrPisSt'], 2, ',', '.');

		//Pegando valores totais de vendas
		$qryVendas = "SELECT COUNT(v.id) as nrVendas, SUM(valor) as vrVendas FROM sat_vendas v
		INNER JOIN sat_equipamentos e ON v.EquipamentoId = e.id
		WHERE DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."' AND e.id = '".$arr['id']."'";
		$arrVendas = mssql_fetch_assoc(mssql_query($qryVendas));
		$arr['valoresTotais']['nrVendas'] = $arrVendas['nrVendas'];
		$arr['valoresTotais']['vrVendas'] = number_format($arrVendas['vrVendas'], 2, ',', '.');

		//Pegando os valores de ICMS
		$qryIcms = "SELECT d.CstIcms, sum(d.valorIcms) as vrCst, sum(ValorItem) as baseCalculo, d.PercentualIcms FROM sat_equipamentos e
		INNER JOIN sat_vendas v ON e.id = v.EquipamentoId
		INNER JOIN sat_imposto i ON v.Imposto_Id = i.id
		INNER JOIN sat_detalheImposto d ON d.Imposto_Id = i.id
		WHERE e.id = ".$arr['id']." AND v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'
		GROUP BY d.CstIcms, d.PercentualIcms
		ORDER BY d.CstIcms";
		
		$resICMS = mssql_query($qryIcms);
		while ($arrICMS = mssql_fetch_assoc($resICMS)) {
			$arrICMS['PercentualIcms'] = number_format($arrICMS['PercentualIcms'], 2, ',', '.');
			$arrICMS['baseCalculo'] = number_format($arrICMS['baseCalculo'], 2, ',', '.');
			$arrICMS['vrCst'] = number_format($arrICMS['vrCst'], 2, ',', '.');
			$arr['ICMS'][] = $arrICMS;
		}

		//Pegando os valores de PIS
		$qryPis = "SELECT d.CstPis, sum(d.valorPis) as vrCst, sum(ValorItem) as baseCalculo, d.PercentualPis FROM sat_equipamentos e
		INNER JOIN sat_vendas v ON e.id = v.EquipamentoId
		INNER JOIN sat_imposto i ON v.Imposto_Id = i.id
		INNER JOIN sat_detalheImposto d ON d.Imposto_Id = i.id
		WHERE e.id = ".$arr['id']." AND v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'
		GROUP BY d.CstPis, d.PercentualPis
		ORDER BY d.CstPis";
		$resPis = mssql_query($qryPis);
		while ($arrPis = mssql_fetch_assoc($resPis)) {
			$arrPis['PercentualPis'] = number_format($arrPis['PercentualPis'], 2, ',', '.');
			$arrPis['baseCalculo'] = number_format($arrPis['baseCalculo'], 2, ',', '.');
			$arrPis['vrCst'] = number_format($arrPis['vrCst'], 2, ',', '.');
			$arr['PIS'][] = $arrPis;
		}

		//Pegando os valores de COFINS
		$qryCofins = "SELECT d.CstCofins, sum(d.valorCofins) as vrCst, sum(ValorItem) as baseCalculo, d.PercentualCofins FROM sat_equipamentos e
		INNER JOIN sat_vendas v ON e.id = v.EquipamentoId
		INNER JOIN sat_imposto i ON v.Imposto_Id = i.id
		INNER JOIN sat_detalheImposto d ON d.Imposto_Id = i.id
		WHERE e.id = ".$arr['id']." AND v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'
		GROUP BY d.CstCofins, d.PercentualCofins
		ORDER BY d.CstCofins";
		$resCofins = mssql_query($qryCofins);
		while ($arrCofins = mssql_fetch_assoc($resCofins)) {
			$arrCofins['PercentualCofins'] = number_format($arrCofins['PercentualCofins'], 2, ',', '.');
			$arrCofins['baseCalculo'] = number_format($arrCofins['baseCalculo'], 2, ',', '.');
			$arrCofins['vrCst'] = number_format($arrCofins['vrCst'], 2, ',', '.');
			$arr['COFINS'][] = $arrCofins;
		}

		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getDadosOperador()
{
	$res = mssql_query("SELECT idOperador, stApelido FROM op_Operadores WHERE idOperador = " . $_COOKIE['idOperador']);
	$arr = mssql_fetch_array($res);
	$arr['stApelido'] = utf8_encode($arr['stApelido']);
	echo json_encode($arr);
}

function getEquipamentos()
{
	$qry = 'SELECT id, serial FROM sat_equipamentos';
	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function relatorioDiario($month, $year, $equipamento)
{
	$lastDay = cal_days_in_month(CAL_GREGORIAN, $month, $year);
	if ($month < 10) {
		$month = '0' . $month;
	}
	$firstDay = $year . '-' . $month . '-01 00:00:00';
	$lastDay = $year . '-' . $month . '-'. $lastDay .' 23:59:59';

	if ($equipamento == 0) {
		$qryTotais = "SELECT DAY(v.DataEmissao) as day, sum(vrIcms) as vrIcms, sum(vrPis) as vrPis, sum(vrCofins) as vrCofins, 
		sum(vrCofinsSt) as vrCofinsSt, sum(vrPisSt) as vrPisSt, sum(vrOutros) as vrOutros FROM sat_imposto i
		INNER JOIN sat_vendas v ON v.Imposto_Id = i.id
		where v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'
		GROUP BY DAY(v.DataEmissao)";
	}else{
		$qryTotais = "SELECT DAY(v.DataEmissao) as day, sum(vrIcms) as vrIcms, sum(vrPis) as vrPis, sum(vrCofins) as vrCofins, 
		sum(vrCofinsSt) as vrCofinsSt, sum(vrPisSt) as vrPisSt, sum(vrOutros) as vrOutros FROM sat_imposto i
		INNER JOIN sat_vendas v ON v.Imposto_Id = i.id
		INNER JOIN sat_equipamentos e ON v.EquipamentoId = e.id
		where e.id = ".$equipamento." AND v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'
		GROUP BY DAY(v.DataEmissao)";
	}
	$resTotais = mssql_query($qryTotais);
	while ($arrTotais = mssql_fetch_assoc($resTotais)) {
		$arr = array();
		$arr['valoresTotais'] = $arrTotais;
		$arr['valoresTotais']['vrCofins'] = number_format($arr['valoresTotais']['vrCofins'], 2, ',', '.');
		$arr['valoresTotais']['vrCofinsSt'] = number_format($arr['valoresTotais']['vrCofinsSt'], 2, ',', '.');
		$arr['valoresTotais']['vrIcms'] = number_format($arr['valoresTotais']['vrIcms'], 2, ',', '.');
		$arr['valoresTotais']['vrOutros'] = number_format($arr['valoresTotais']['vrOutros'], 2, ',', '.');
		$arr['valoresTotais']['vrPis'] = number_format($arr['valoresTotais']['vrPis'], 2, ',', '.');
		$arr['valoresTotais']['vrPisSt'] = number_format($arr['valoresTotais']['vrPisSt'], 2, ',', '.');

		if ($arr['valoresTotais']['day'] < 10) {
			$arr['valoresTotais']['day'] = '0'.$arr['valoresTotais']['day'];
		}
		$firstDay = $year . '-' . $month . '-'. $arr['valoresTotais']['day'] .' 00:00:00';
		$lastDay = $year . '-' . $month . '-'. $arr['valoresTotais']['day'] .' 23:59:59';

		//Pegando valores totais de vendas
		$qryVendas = "SELECT COUNT(v.id) as nrVendas, SUM(valor) as vrVendas FROM sat_vendas v
		INNER JOIN sat_equipamentos e ON v.EquipamentoId = e.id
		WHERE DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'";
		if ($equipamento != 0) {
			$qryVendas .= " AND e.id = '".$equipamento."'";
		} 
		$arrVendas = mssql_fetch_assoc(mssql_query($qryVendas));
		$arr['valoresTotais']['nrVendas'] = $arrVendas['nrVendas'];
		$arr['valoresTotais']['vrVendas'] = number_format($arrVendas['vrVendas'], 2, ',', '.');

		//Pegando os valores de ICMS
		$qryIcms = "SELECT d.CstIcms, sum(d.valorIcms) as vrCst, sum(ValorItem) as baseCalculo, d.PercentualIcms FROM sat_equipamentos e
		INNER JOIN sat_vendas v ON e.id = v.EquipamentoId
		INNER JOIN sat_imposto i ON v.Imposto_Id = i.id
		INNER JOIN sat_detalheImposto d ON d.Imposto_Id = i.id
		WHERE v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'";
		if ($equipamento != 0) {
			$qryIcms .= " AND e.id = '".$equipamento."'";
		}
		$qryIcms .= "GROUP BY d.CstIcms, d.PercentualIcms
		ORDER BY d.CstIcms";
		// var_dump($qryIcms);
		$resICMS = mssql_query($qryIcms);
		while ($arrICMS = mssql_fetch_assoc($resICMS)) {
			$arrICMS['PercentualIcms'] = number_format($arrICMS['PercentualIcms'], 2, ',', '.');
			$arrICMS['baseCalculo'] = number_format($arrICMS['baseCalculo'], 2, ',', '.');
			$arrICMS['vrCst'] = number_format($arrICMS['vrCst'], 2, ',', '.');
			$arr['ICMS'][] = $arrICMS;
		}

		//Pegando os valores de PIS
		$qryPis = "SELECT d.CstPis, sum(d.valorPis) as vrCst, sum(ValorItem) as baseCalculo, d.PercentualPis FROM sat_equipamentos e
		INNER JOIN sat_vendas v ON e.id = v.EquipamentoId
		INNER JOIN sat_imposto i ON v.Imposto_Id = i.id
		INNER JOIN sat_detalheImposto d ON d.Imposto_Id = i.id
		WHERE v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'";
		if ($equipamento != 0) {
			$qryPis .= " AND e.id = '".$equipamento."'";
		}
		$qryPis .=" GROUP BY d.CstPis, d.PercentualPis
		ORDER BY d.CstPis";
		// var_dump($qryPis);
		$resPis = mssql_query($qryPis);
		while ($arrPis = mssql_fetch_assoc($resPis)) {
			$arrPis['PercentualPis'] = number_format($arrPis['PercentualPis'], 2, ',', '.');
			$arrPis['baseCalculo'] = number_format($arrPis['baseCalculo'], 2, ',', '.');
			$arrPis['vrCst'] = number_format($arrPis['vrCst'], 2, ',', '.');
			$arr['PIS'][] = $arrPis;
		}

		//Pegando os valores de COFINS
		$qryCofins = "SELECT d.CstCofins, sum(d.valorCofins) as vrCst, sum(ValorItem) as baseCalculo, d.PercentualCofins FROM sat_equipamentos e
		INNER JOIN sat_vendas v ON e.id = v.EquipamentoId
		INNER JOIN sat_imposto i ON v.Imposto_Id = i.id
		INNER JOIN sat_detalheImposto d ON d.Imposto_Id = i.id
		WHERE v.DataEmissao BETWEEN '".$firstDay."' AND '".$lastDay."'";
		if ($equipamento != 0) {
			$qryCofins .= " AND e.id = '".$equipamento."'";
		}
		$qryCofins .= "GROUP BY d.CstCofins, d.PercentualCofins
		ORDER BY d.CstCofins";
		$resCofins = mssql_query($qryCofins);
		while ($arrCofins = mssql_fetch_assoc($resCofins)) {
			$arrCofins['PercentualCofins'] = number_format($arrCofins['PercentualCofins'], 2, ',', '.');
			$arrCofins['baseCalculo'] = number_format($arrCofins['baseCalculo'], 2, ',', '.');
			$arrCofins['vrCst'] = number_format($arrCofins['vrCst'], 2, ',', '.');
			$arr['COFINS'][] = $arrCofins;
		}

		$rows[] = $arr;
	}
	echo json_encode($rows);
}

?>