<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ClosingHistory extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_HistoricoFechamento';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'id',
        'id_open',
        'value_apured',
        'value_closure',
        'difference',
        'date',
        'updated_at',
    ];

    protected $hidden = [
        'idAbertura',
        'vrApurado',
        'vrFechamento',
        'vrDiferenca',
        'dtData',
        'dtAlteracao',
    ];

    protected $maps = [
        'id_open' => 'idAbertura',
        'value_apured' => 'vrApurado',
        'value_closure' => 'vrFechamento',
        'difference' => 'vrDiferenca',
        'date' => 'dtData',
        'updated_at' => 'dtAlteracao',
    ];

    protected $appends = [
        'id_open',
        'value_apured',
        'value_closure',
        'difference',
        'date',
        'updated_at',
    ];

}
