<?php

namespace App\Entities\Financeiro;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Conta extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "fin_Contas";
    protected $primaryKey = "idConta";
    public $timestamps = false;
    protected $fillable = [
        'idConta',
        'idTipoConta',
        'stConta',
        'dtAlteracao'
    ];

    protected $casts = [
        'idConta' => 'int',
        'idTipoConta' => 'int',
    ];

    public function subGrupo()
    {
        return $this->belongsTo(SubGrupo::class, 'idTipoConta')->with('grupo');
    }

}
