<?php

namespace App\Entities\Nati\ExportProductsScale;

use App\Entities\Nati\ExportProductsScale\FileGenerator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class FileGeneratorFilizola implements FileGenerator
{
    protected $productsIds;

    protected function setProductsIds($productsIds)
    {
        $this->productsIds = $productsIds;
    }


    public function generateItensFile($productsIds, $generateAdditionalInformationFile = false)
    {
        $this->setProductsIds($productsIds);

        $file = $this->formatItensFile();

        $response = $this->saveFile("CADTXT.TXT", $file);

        return $response;
    }

    public function formatItensFile()
    {
        $products = $this->getProducts();

        $file = '';
        foreach($products as $item)
        {
            $rowFile = '';
            $product = json_decode(json_encode($item), true);

            for ($x=0; $x < (6 - strlen($product['idCodigo'])); $x++)
            $rowFile .= "0";

            $rowFile .= $product['idCodigo'];

            if ($product['flFracionado'] == 1){
                $rowFile .= "P";
            }else{
                $rowFile .= "U";
            }

            $stProduto = strtoupper($product['stProduto']);

            if (strlen($stProduto) < 22){
                $rowFile .= $stProduto;

                for ($x=0;$x<(22-strlen($stProduto));$x++)
                    $rowFile .= " ";
            }else{
                $stProduto = substr($stProduto, 0, 22);
                $rowFile .= $stProduto;
            }

            $vrUnitario = number_format($product['vrUnitario'], 2, "", "");

            for ($x=0;$x<(7-strlen($vrUnitario));$x++)
                    $rowFile .= "0";
            $rowFile .= $vrUnitario;

            for ($x=0;$x<(3-strlen($product['nrValidade']));$x++)
            {
                $rowFile .= "0";
            }

            $rowFile .= $product['nrValidade'];
            $rowFile .= "\r\n";

            $file .= $rowFile;
        }
        return $file;
    }

    public function saveFile($nameFile, $file)
    {
        $erro = false;
        $path = Storage::path($nameFile);
        @unlink($path, $nameFile);
        $fopen = @fopen($path, "w") or $erro = true;
        @fwrite($fopen, $file) or $erro = true;
        @fclose($fopen) or $erro = true;
    }

    public function getProducts()
    {
        $productsIds = $this->productsIds->all();
        foreach($productsIds as $item) {
            $arr[] = $item['idProduto'];
        }
        $productsIds = implode(',', $arr);

        $query = "SELECT M.idMedida, C.idCodigo, P.stProduto, P.nrValidade, M.flFracionado,
            CASE
            WHEN P.flPromocao = '1' AND GETDATE() BETWEEN P.dtInicioPromocao AND P.dtFimPromocao THEN P.vrUnitarioPromocao
            ELSE P.vrUnitario
            END AS vrUnitario
            FROM prd_Produtos P
            INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
            INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
            WHERE P.flAtivo = '1' AND LEN(C.idCodigo) <= 6 AND p.idProduto in ($productsIds)
            ORDER BY P.stProduto";
        $products = DB::select($query);
        return $products;
    }

    public function generateNutritionalInformationFile()
    {
        $file = $this->formatNutritionalInformationFile();

        $response = $this->saveFile("NUTRI.TXT", $file);
    }

    public function formatNutritionalInformationFile()
    {
        $str = null;
        $file = '';
        $nutritionalInformations = $this->getNutritionalInformation();
        foreach($nutritionalInformations as $item) {
            $product = json_decode(json_encode($item), true);
            //Configuração campo codigo
            $incremento = null;
            $str1 = $product['idProduto'];
            $count = strlen($str1);
            $qtdCpCodigo = 6;

            $increase = $qtdCpCodigo - $count ;
            for ($index = 0; $index < $increase; $index++) {
                $incremento .= "0" ;
            }
            $codigo = $incremento.$str1;

            //Configuração campo tipo
            $tipo = $product['tipo'];

            /** configuração campo descrição*/
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;
            // $str2 = $product['nrQuantidade'].$product['medida'];
            // $str2 = str_replace(' ','_', $str2);
            // $count = strlen($str2);
            // $qtdCpDesc = 35;
            // $increase = $qtdCpDesc - $count;
            // for ($index = 0; $index < $increase; $index++) {
            //     $incremento .= "0" ;
            // }
            // $desc = $str2.$incremento;
            $product['stProduto'] = strtoupper(utf8_encode($product['stProduto']));
            if (strlen($product['stProduto']) > 22) {
                $product['stProduto'] = substr($product['stProduto'], 0, 22);
            }
            if (strlen($product['stProduto']) < 25) {
                $product['stProduto'] = str_pad($product['stProduto'], 22, ' ', STR_PAD_RIGHT);
            }
            $desc = $product['stProduto'];

            //configuração preço
            $preco = '';
            $vrUnitario = number_format($product['vrUnitario'], 2, "", "");
            for ($x=0;$x<(7-strlen($vrUnitario));$x++)
                    $preco .= "0";
            $preco .= $vrUnitario;

            //configuracao validade
            $validade = '';
            for ($x=0;$x<(3-strlen($product['nrValidade']));$x++)
            {
                $validade .= "0";
            }
            $validade .= $product['nrValidade'];

            //separador
            $separador = '@';

            //Descrição porcao
            $descPorcao = '###################################';

            /** configuração campo vrCalorico (vrEnergetico)*/
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str3 = $product['vrCalorico'];
            $count = strlen($str3);
            $qtdCpvrCal = 5;
            $increase = $qtdCpvrCal - $count;
            for ($index = 0; $index < $increase; $index++) {
                $incremento .= "0" ;
            }
            $vrEnergetico = $incremento.$str3;

            /** configuração campo vrCaloricoPercentual */
            $PerCalorico = $product['PerCalorico'];

            /** configuração campo nrCarboidratos */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str5 = $product['nrCarboidratos'];
            $count = strlen($str5);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
                $incremento .= "0" ;
            }
            $nrCarboidratos = $incremento.$str5;
            $nrCarboidratos = number_format($nrCarboidratos, 2, "", "");

            /** configuração campo PerCarboidratos */
            $PerCarboidratos = $product['PerCarboidratos'];

            /** configuração campo nrProteinas */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str7 = $product['nrProteinas'];
            $count = strlen($str7);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
                $incremento .= "0" ;
            }
            $nrProteinas = $incremento.$str7;
            $nrProteinas = number_format($nrProteinas, 2, "", "");

            /** configuração campo PerProteinas */
            $PerProteinas = $product['PerProteinas'];

            /** configuração campo nrGordurasTotais */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str9 = $product['nrGordurasTotais'];
            $count = strlen($str9);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
                $incremento .= "0" ;
            }
            $nrGordurasTotais = $incremento.$str9;
            $nrGordurasTotais = number_format($nrGordurasTotais, 2, "", "");

            /** configuração campo PerGordurasTotais */
            $PerGordurasTotais = $product['PerGordurasTotais'];

            /** configuração campo nrGordurasSaturadas */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str11 = $product['nrGordurasSaturadas'];
            $count = strlen($str11);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
                $incremento .= "0" ;
            }
            $nrGordurasSaturadas = $incremento.$str11;
            $nrGordurasSaturadas = number_format($nrGordurasSaturadas, 2, "", "");

            /** configuração campo PerGordurasSaturadas */
            $PerGordurasSaturadas = $product['PerGordurasSaturadas'];

            /*configuração campo colesterol*/
            $colesterol = $product['colesterol'];

            /*configuração campo Percolesterol*/
            $Percolesterol = $product['Percolesterol'];

            /*configuração campo nrFibraAlimentar*/
            $nrFibraAlimentar = $product['nrFibraAlimentar'];
            $nrFibraAlimentar = number_format($nrFibraAlimentar, 2, "", "");

            /*configuração campo PerFibraAlimentar*/
            $PerFibraAlimentar = $product['PerFibraAlimentar'];

            /*configuração campo calcio,PercCalcio,ferro,PercFerro,nrSodio,PercSodio*/
            $calcio = $product['calcio'] ;
            $PercCalcio = $product['PercCalcio'];
            $ferro = $product['ferro'];
            $PercFerro = $product['PercFerro'];
            $nrSodio = number_format($product['nrSodio'], 2, "", "");
            $PercSodio = $product['PercSodio'];

            $file .= $codigo.$tipo.$desc.$preco.$validade.$separador.$descPorcao.$vrEnergetico.$PerCalorico.$nrCarboidratos.$PerCarboidratos.
                $nrProteinas.$PerProteinas.$nrGordurasTotais.$PerGordurasTotais.
                $nrGordurasSaturadas.$PerGordurasSaturadas.$colesterol.$Percolesterol.
                $nrFibraAlimentar.$PerFibraAlimentar.$calcio.$PercCalcio.$ferro.
                $PercFerro.$nrSodio.$PercSodio."\r\n";
        }
        return $file;
    }

    public function getNutritionalInformation($idProduto = null)
    {
        $productsIds = $this->productsIds->all();
        foreach($productsIds as $item) {
            $arr[] = $item['idProduto'];
        }
        $productsIds = implode(',', $arr);
        $query = "SELECT
                    a.idProduto,
                    a.nrQuantidade,
                    b.stProduto,
                    b.nrValidade,
                    b.vrUnitario,
                    case
						m.flfracionado
						when 0 then 'U'
						when 1 then 'P'
						end as tipo,
                    case
                    a.nrUnidadePorcao
                    when 0 then 'g'
                    when 1 then 'ml'
                    when 2 then 'un'
                    else ''
                        end as medida,
                    a.nrValorEnergetico as vrCalorico,
                    ('0000') as PerCalorico,
                    a.nrCarboidratos,
                    ('0000') as PerCarboidratos,
                    a.nrProteinas,
                    ('0000') as PerProteinas,
                    a.nrGordurasTotais,
                    ('0000') as PerGordurasTotais,
                    a.nrGordurasSaturadas,
                    ('0000') as PerGordurasSaturadas,
                    '00000' as colesterol,
                    '0000' as Percolesterol,
                    a.nrFibraAlimentar,
                    ('0000') as PerFibraAlimentar,
                    ('*****') as calcio,
                    ('****') as PercCalcio,
                    ('*****') as ferro,
                    ('****')  as PercFerro,
                    a.nrSodio,
                    ('0000') as PercSodio
                    FROM prd_TabelasNutricionais a
                    inner join prd_produtos b on b.idProduto = a.idProduto
                    inner join prd_medidas m on m.idMedida = b.idMedida
                    where a.idProduto in ($productsIds)";

        $nutritionalInformations = DB::select($query);
        return $nutritionalInformations = json_decode(json_encode($nutritionalInformations), true);
    }

    public function generateSetorFile()
    {
        $file = $this->formatSetorFile();

        $response = $this->saveFile("SETORTXT.TXT", $file);
    }

    public function formatSetorFile()
    {
        $file = "";
        $nrIndice = (-1);
        $setores = $this->getSetores();

        foreach($setores as $item) {
            if (strlen($stSetor) < 12)
            {
                $file .= $stSetor;

                for ($x=0;$x<(12-strlen($stSetor));$x++)
                {
                    $file .= " ";
                }
            }
            else
            {
                $stSetor = substr($stSetor, 0, 12);

                $file .= $stSetor;
            }

            for ($x=0;$x<(6-strlen($item['idCodigo']));$x++)
            {
                $file .= "0";
            }

            $file .= $item['idCodigo'];

            $nrIndice++;

            for ($x=0;$x<(4-strlen($nrIndice));$x++)
            {
                $file .= "0";
            }

            $file .= $nrIndice;

            $file .= "000";

            $file .= "\r\n";
        }

        return $file;
    }

    public function getSetores()
    {
        $productsIds = implode(",", $this->productsIds);
        $query =  "SELECT S.stSetor, C.idCodigo FROM prd_Produtos P
		INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
		INNER JOIN prd_Setores S ON P.idSetor = S.idSetor
		INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
		WHERE P.flAtivo = '1' AND LEN(C.idCodigo) <= 6 AND p.idProduto in ($productsIds)
		ORDER BY P.stProduto";

        $setores = DB::select($query);
        return $setores = json_decode(json_encode($setores), true);
    }

    // public function generateAdditionalInformationFile()
    // {

    // }

    // public function formatAdditionalInformationFile()
    // {

    // }

    public function cleanString($text) {
        $utf8 = array(
            '/[áàâãªä]/u'   =>   'a',
            '/[ÁÀÂÃÄ]/u'    =>   'A',
            '/[ÍÌÎÏ]/u'     =>   'I',
            '/[íìîï]/u'     =>   'i',
            '/[éèêë]/u'     =>   'e',
            '/[ÉÈÊË]/u'     =>   'E',
            '/[óòôõºö]/u'   =>   'o',
            '/[ÓÒÔÕÖ]/u'    =>   'O',
            '/[úùûü]/u'     =>   'u',
            '/[ÚÙÛÜ]/u'     =>   'U',
            '/ç/'           =>   'c',
            '/Ç/'           =>   'C',
            '/ñ/'           =>   'n',
            '/Ñ/'           =>   'N',
            '/–/'           =>   '-', // UTF-8 hyphen to "normal" hyphen
            '/[’‘‹›‚]/u'    =>   ' ', // Literally a single quote
            '/[“”«»„]/u'    =>   ' ', // Double quote
            '/ /'           =>   ' ', // nonbreaking space (equiv. to 0x160)
        );
        return preg_replace(array_keys($utf8), array_values($utf8), $text);
    }
}
