<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Localizacao extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'prd_Localizacoes';
    public $primaryKey = 'idLocalizacao';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idLocalizacao',
        'stLocalizacao',
        'flAtivo',
        'dtAlteracao',
    ];

    protected $casts = [
        'flAtivo'  => 'boolean',
    ];

    public function produtos()
    {
        return $this->hasMany(Product::class, 'idLocalizacao');
    }

    public function getProdutosCountAttribute()
    {
        return $this->produtos()->count();
    }

}
