<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class OrderItem extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mt_Itens';
    protected $primaryKey = ['idComanda', 'nrItem'];
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idComanda',
        'nrItem',
        'idPessoa',
        'idProduto',
        'stOperador',
        'nrQuantidade',
        'dtData',
        'idMicroterminal',
        'vrUnitario',
        'vrTotal',
        'flNovo',
        'stIncremento',
        'stValores',
        'stCodigos',
        'stQuantidades',
        'stItensAdicionais',
        'flItemAdicional',
        'flAgregaValor',
        'flViagem',
        'nrItemVinculado',
        'flSem',
        'dtAlteracao',
    ];

    protected $casts = [
        'flItemAdicional' => 'boolean',
        'flAgregaValor' => 'boolean',
        'flViagem' => 'boolean',
        'vrUnitario' => 'float',
        'nrQuantidade' => 'float',
        'vrTotal' => 'float',
        'flSem' => 'boolean',
    ];

    public function item(){
        return $this->hasOne(Product::class, 'idProduto', 'idProduto');
    }
}
