<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Sector extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'prd_Setores';
    protected $primaryKey = 'idSetor';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idSetor',
        'stSetor',
        'flAtivo',
        'dtAlteracao',
    ];

    protected $hidden = [
        'stReservaCodigosFim',
        'stReservaCodigosInicio',
        'sync'
    ];

    protected $casts = [
        'idSetor'=>'integer',
        'flAtivo' => 'boolean',
    ];

    protected $appends = [
        'produtos_count'
    ];

    public function produtos()
    {
        return $this->hasMany(Product::class, 'idSetor', 'idSetor')->where('flAtivo' ,true);
    }

    public function getProdutosCountAttribute()
    {
        return $this->produtos()->count();
    }
}
