<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;


class StockBalance extends Model implements Transformable
{
    use TransformableTrait;

    protected $primaryKey = ['idSaldo', 'idEstoque', 'idProduto'];
    protected $table = 'est_Saldos';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idSaldo',
        'idEstoque',
        'idProduto',
        'nrQuantidade',
        'nrReservas',
        'dtModificacao',
        'dtConferencia',
        'nrMinimo',
        'dtAlteracao',
    ];

    protected $casts = [
        'idSaldo' => 'integer',
        'nrQuantidade' => 'float',
        'nrReservas' => 'float'
    ];

    public function produto()
    {
        return $this->belongsTo(Product::class,'idProduto','idProduto');
    }
}
