<?php

namespace App\Http\Controllers;

use App\Http\Requests\CEPsCreateRequest;
use App\Services\CEPService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;

class CEPsController extends Controller
{
    protected $service;

    public function __construct(CEPService $service)
    {
        $this->service = $service;
    }

    /**
     * Display the specified resource.
     *
     * @param int $cep
     *
     * @return \Exception|\GuzzleHttp\Exception\GuzzleException|\Illuminate\Http\JsonResponse
     */
    public function show($cep)
    {
        try {
            return $this->service->getByCEP($cep);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function store(CEPsCreateRequest $request)
    {
        try {
            $perfil = $this->service->insertCep($request->all());

            $response = [
                'message' => 'CEP created.',
                'data' => $perfil->toArray(),
            ];
            return response()->json($response, 201);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }

    /**
     * Searches the specified resource
     *
     * @param string $text
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function search($text)
    {
        try {
            $response = $this->service->search($text);
            return response()->json($response);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function apiGetCep($cep)
    {
        try {
            return $this->service->apiGetCep($cep);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function getCepById($cep)
    {
        try {
            $response = $this->service->getById($cep);
            return response()->json([
                'data' => $response,
                'message' => 'Success'
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function apiOnlineGetCep($cep)
    {
        try {
            return $this->service->apiOnlineGetCep($cep);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

}
