<?php

namespace App\Http\Controllers;

use App\Entities\SalesView;
use App\Entities\Entregador;
use App\Entities\Prints;
use App\Http\Controllers\Controller;

use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\EntregadorCreateRequest;
use App\Http\Requests\EntregadorUpdateRequest;
use App\Repositories\EntregadorRepository;
use App\Validators\EntregadorValidator;

/**
 * Class EntregadorsController.
 *
 * @package namespace App\Http\Controllers;
 */
class EntregadoresController extends Controller
{
    /**
     * @var EntregadorRepository
     */
    protected $repository;

    /**
     * @var EntregadorValidator
     */
    protected $validator;

    /**
     * EntregadorsController constructor.
     *
     * @param EntregadorRepository $repository
     * @param EntregadorValidator $validator
     */
    public function __construct(EntregadorRepository $repository, EntregadorValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        $entregadors = $this->repository->all();

        return response()->json($entregadors);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param EntregadorCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function store(EntregadorCreateRequest $request)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_CREATE);

            $x = $request->all();

            $request['idMotoboy'] = $this->nextId();
            $request->request->add(['flAtivo' => true]);
            $request->request->add(['dtAlteracao' => Carbon::now()]);


            $entregador = $this->repository->create($request->all());

            $response = [
                'message' => 'Entregador created.',
                'data' => $entregador->toArray(),
            ];

            return response()->json($response);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ]);
        }
    }

    private function nextId()
    {
        return Entregador::max('idMotoboy') + 1;
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $entregador = $this->repository->find($id);

        return response()->json([
            'data' => $entregador,
        ]);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param EntregadorUpdateRequest $request
     * @param string $id
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function update(EntregadorUpdateRequest $request, $id)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_UPDATE);

            $entregador = $this->repository->update($request->all(), $id);

            $response = [
                'message' => 'Entregador updated.',
                'data' => $entregador->toArray(),
            ];

            return response()->json($response);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $deleted = $this->repository->delete($id);

        return response()->json([
            'message' => 'Entregador deleted.',
            'deleted' => $deleted,
        ]);
    }
}
