<?php
/**
 * Created by PhpStorm.
 * User: ARCNET DEV
 * Date: 21/11/2017
 * Time: 14:37
 */

namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use App\Services\PaymentFormService;
use Illuminate\Http\Request;

class FichaPagamentoController extends Controller
{
    protected $fichService;

    /**
     * Constructor for FichaPagamentoController
     *
     * @param PaymentFormService $fichaService
     */
    public function __construct(PaymentFormService $fichaService)
    {
        $this->fichService = $fichaService;
    }


    /**
     * Updates the specified resource
     *
     * @param Request $request
     * @param integer $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id)
    {
        $response = $this->fichService
            ->update($id, $request->idVenda, $request->idAbertura, $request->temp, $request->data);

        return response()->json($response, 200);
    }
}
